#include <stdio.h>
#include <math.h>
#include <string.h>
#include <sys/time.h>

int main(int argc, char *argv[]) {
  double k=0.05;
  double B=7.5; 
  double x0;
  double x1=3.0;
  double x2;
  double dx=4.0;
  double dt=M_PI/300; 
  double ddt; 
  int  i,j=0;

  ddt    = dt*dt; 
  x0     =x1-dx*dt;

  while (1) {
    fd_set stdin_set;
    struct timeval timeout = { 0, 0 };
    FD_ZERO(& stdin_set);
    FD_SET(fileno(stdin), &stdin_set);
    if (select(fileno(stdin)+1, & stdin_set,
              NULL, NULL, & timeout)>0) {
      char line[128], Name[128];
      float Value;
      fgets(line, sizeof(line), stdin);
      sscanf (line, "%s %f", Name, &Value);
      if (strcmp(Name,"k")==0) k=(double) Value;
      if (strcmp(Name,"B")==0) B=(double) Value;
    }
   
    for (i=0; i<100; i++, j++) {
      x2 = (ddt*B * cos(j*dt) + (2+dt*k)*x1 -x0 - 
            ddt*x1*x1*x1)/(1+dt*k);
      if ((j%1) == 0) printf("%f %f\n",x2,(x2-x1)/dt);
      x0=x1; x1=x2;
      }
  }
  return 0;
}
