*\
 *  This Flash actionscript file is part of a PITF project
 *  Copyright (C) 2004-2005  David Mahfouda and Oliver Knill, Harvard University
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

//vector functions and scaling factors for cursor animations

//function P(x,y)   { return exp(y,3); }
//function Q(x,y)   { return 3*exp(x,2)*y; }
//function rot(x,y) { return 3*y*y-6*x; }
//function div(x,y) { return 6*exp(x,2); }
//adaptrot = 120000;
//adaptdiv = 400000;

  function P(x,y)   { return 10*x*y; }
  function Q(x,y)   { return 10*(x-y); }
  function rot(x,y) { return 10*(1-x); }
  function div(x,y) { return 10*(y-1); }
  adaptrot = 12000;
  adaptdiv = 40000; 

// preparations
x_center = 200;           // body center
y_center = 200;           // body center
nvec = 5;                 // number of vectors per half plane
rr = 60;                  // size of wheel
ss = 60;                  // size of box
spacing = 37;             // spacing between vectors in field 
mathpi180 = Math.PI/180;  // a constant which often occurs
onethird  = 2*Math.PI/3;  // dito
a=0.3;                    // length of head
b=0.1;                    // width of head
c=10;                     // shadow displacement
choice = 2;               // 1 = div,  2 = curl
field  = 1;               // kind of vector field
nfield = 2;               // number of vector fields

init(); 

function init() {
  _root.createEmptyMovieClip("cursor",1);
  axes();
  vfield();
  textt();
}

onEnterFrame = function() {
     mousemove();
     if (choice==2) { cursorspin(fieldcurl);   }
     if (choice==1) { cursorexpand(fielddiv);  }
}


//reads curl of vector field at mouse location
function mousemove() {
 // if(Key.isDown(Key.LEFT))       { choice=2; }
 // if(Key.isDown(Key.RIGHT))      { choice=1; }
    if(Key.isDown(68)) { choice=1; }    // 68 is keycode for "d" for div
    if(Key.isDown(67)) { choice=2; }    // 82 is keycode for "c" for curl 


    if(Key.isDown(Key.PGUP))       { 
           field=field+1; 
           if (field>=nfield+1) { field=1; } 
    }
    xx = _xmouse - x_center;     
    yy = _ymouse - y_center;           
    fieldcurl = rot(xx,yy); 
    fielddiv  = div(xx,yy); 
    curl.text = "Curl: " + fieldcurl; 
    div.text  = "Divergence: " + divcurl; 
}

//draw coordinate axes
function axes() {
     //y-axis
     _root.lineStyle(2,000000,30);
     _root.moveTo(x_center,20);
     _root.lineTo(x_center,380);
     vec0(x_center,18,x_center,0,2,0,0,0,30);
      //x-axis
      _root.moveTo(20, y_center);
      _root.lineTo(380, y_center);
     vec0(382,y_center,400,y_center,2,0,0,0,30);
}

// create text boxes to see curl or div
function textt () {
      _root.createTextField("curl", 0, 300, 370, 200, 30);
      _root.createTextField("div", 0, 200, 370, 200, 30);
}

//graph vector field
function vfield() {
    for (i=-nvec; i<nvec; i++) {
        for (j=-nvec; j<nvec; j++) {
              // relative coordinates
              x1 = x_center + spacing*i;
              y1 = y_center + spacing*j;
              _root.moveTo(x1, y1);
              //defining the individual vectors
              pp= P(1.5*i, 1.5*-j);
              qq= Q(1.5*i, 1.5*-j);
              //finding the length of vector
              ll = leng(pp,qq);
              //scaling vectors
              x2 = x1 + scale(ll)*10*pp/ll;
              y2 = y1 + scale(ll)*10*qq/ll;
              //j's are negative because "down" is positive
              vec(x1,y1,x2,y2,1,255,0,0,100)
          }
      }
}

// drawing vectors function with shadow
function vec(x1,y1,x2,y2,thick,red,green,blue,z) {
      x3=x1+(1-a)*(x2-x1); y3=y1+(1-a)*(y2-y1);
      x4=x3+b*(y1-y2);     y4=y3+b*(x2-x1);
      x5=x3-b*(y1-y2);     y5=y3-b*(x2-x1);
     _root.lineStyle(thick,red<<16^green<<8^blue,z);
     _root.moveTo(x1,y1);
     _root.lineTo(x3,y3);
     _root.moveTo(x2,y2);
     _root.lineTo(x4,y4);
     _root.lineTo(x5,y5);
     _root.lineTo(x2,y2);
     _root.lineStyle(thick,red<<16^green<<8^blue,20);
     _root.moveTo(x1+c,y1);
     _root.lineTo(x3+c,y3);
     _root.moveTo(x2+c,y2);
     _root.lineTo(x4+c,y4);
     _root.lineTo(x5+c,y5);
     _root.lineTo(x2+c,y2);
}

// drawing vectors function without shadow
function vec0(x1,y1,x2,y2,thick,red,green,blue,z) {
      x3=x1+(1-a)*(x2-x1); y3=y1+(1-a)*(y2-y1);
      x4=x3+b*(y1-y2);     y4=y3+b*(x2-x1);
      x5=x3-b*(y1-y2);     y5=y3-b*(x2-x1);
     _root.lineStyle(thick,red<<16^green<<8^blue,z);
     _root.moveTo(x1,y1);
     _root.lineTo(x3,y3);
     _root.moveTo(x2,y2);
     _root.lineTo(x4,y4);
     _root.lineTo(x5,y5);
     _root.lineTo(x2,y2);
}



//arctan scaling function
function scale(number) { return 2*Math.atan(number/100); }


//exponent function
function exp(base,n) {
    if (n == 0) { return 1; } else { return exp(base,n-1)*base; }
}

//length function
function leng(x,y) { return Math.sqrt(0.0001+x*x + y*y); }

expand = 0;
function cursorexpand(div) {
	Mouse.hide();
	cx = _xmouse; cy = _ymouse;
        speed = div/adaptdiv;
        expand  = expand + speed; 
        expand1 = expand + 0.5; 
        if (expand>1) { expand=0; }
        if (expand<0) { expand=1; }
        if (expand1>1) { expand1=expand1-1; }
        cursor.clear();
        pp = ss*expand;
	cursor.lineStyle (2,0x0000ff,100*(1-expand/2));
	cursor.moveTo (cx-pp,cy-pp);
        cursor.lineTo (cx+pp,cy-pp); 
        cursor.lineTo (cx+pp,cy+pp); 
        cursor.lineTo (cx-pp,cy+pp); 
        cursor.lineTo (cx-pp,cy-pp); 
	cursor.lineStyle (2,0x0000ff,20*(1-expand/2));
	cursor.moveTo (cx-pp+c,cy-pp+c);
        cursor.lineTo (cx+pp+c,cy-pp+c); 
        cursor.lineTo (cx+pp+c,cy+pp+c); 
        cursor.lineTo (cx-pp+c,cy+pp+c); 
        cursor.lineTo (cx-pp+c,cy-pp+c); 
        pp = ss*expand1;
        cursor.lineStyle (2,0x00ff00,100*(1-expand1/2));
        cursor.moveTo (cx-pp,cy-pp);
        cursor.lineTo (cx+pp,cy-pp);
        cursor.lineTo (cx+pp,cy+pp);
        cursor.lineTo (cx-pp,cy+pp);
        cursor.lineTo (cx-pp,cy-pp);
        cursor.lineStyle (2,0x00ff00,20*(1-expand1/2));
        cursor.moveTo (cx-pp+c,cy-pp+c);
        cursor.lineTo (cx+pp+c,cy-pp+c);
        cursor.lineTo (cx+pp+c,cy+pp+c);
        cursor.lineTo (cx-pp+c,cy+pp+c);
        cursor.lineTo (cx-pp+c,cy-pp+c);
}

phi = 0
function cursorspin(curl) {
	Mouse.hide();
	cx = _xmouse; cy = _ymouse;
	speed = curl/adaptrot;
        phi=phi+speed; 
	cursor.clear();
	pp1 = rr*Math.cos(phi);
	qq1 = rr*Math.sin(phi);
	pp2 = rr*Math.cos(phi + onethird);
	qq2 = rr*Math.sin(phi + onethird);
	pp3 = rr*Math.cos(phi - onethird);
	qq3 = rr*Math.sin(phi - onethird);

	cursor.lineStyle (2,0x00ff00,100);
	cursor.moveTo (cx+pp1,cy+qq1);
	cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0x00ff00,20);
        cursor.moveTo (cx+pp1+c,cy+qq1+c);
        cursor.lineTo (cx+c,cy+c);

	cursor.lineStyle (2,0xff0000,100);
	cursor.moveTo (cx+pp2,cy+qq2);
	cursor.lineTo (cx,cy);
	cursor.lineStyle (2,0xff0000,20);
	cursor.moveTo (cx+pp2+c,cy+qq2+c);
	cursor.lineTo (cx+c,cy+c);

	cursor.lineStyle (2,0x0000ff,100);
	cursor.moveTo (cx+pp3,cy+qq3);
	cursor.lineTo (cx,cy);
	cursor.lineStyle (2,0x0000ff,20);
	cursor.moveTo (cx+pp3+c,cy+qq3+c);
	cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0xff00ff,100);
        cursor.moveTo (cx-pp1,cy-qq1);
        cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0xff00ff,20);
        cursor.moveTo (cx-pp1+c,cy-qq1+c);
        cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0x00ffff,100);
        cursor.moveTo (cx-pp2,cy-qq2);
        cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0x00fffff,20);
        cursor.moveTo (cx-pp2+c,cy-qq2+c);
        cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0xffff00,100);
        cursor.moveTo (cx-pp3,cy-qq3);
        cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0xffff00,20);
        cursor.moveTo (cx-pp3+c,cy-qq3+c);
        cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0xeeeeee,100);
        cursor.moveTo (cx+pp1,cy+qq1);
        cursor.lineTo (cx-pp3,cy-qq3);
        cursor.lineTo (cx+pp2,cy+qq2);
        cursor.lineTo (cx-pp1,cy-qq1);
        cursor.lineTo (cx+pp3,cy+qq3);
        cursor.lineTo (cx-pp2,cy-qq2);
        cursor.lineTo (cx+pp1,cy+qq1);
        cursor.lineStyle (2,0xeeeeee,20);
        cursor.moveTo (cx+pp1+c,cy+qq1+c);
        cursor.lineTo (cx-pp3+c,cy-qq3+c);
        cursor.lineTo (cx+pp2+c,cy+qq2+c);
        cursor.lineTo (cx-pp1+c,cy-qq1+c);
        cursor.lineTo (cx+pp3+c,cy+qq3+c);
        cursor.lineTo (cx-pp2+c,cy-qq2+c);
        cursor.lineTo (cx+pp1+c,cy+qq1+c);
}


//show vector field equation
root.createTextField("equation",1, 10, 20, 300, 30);
//print equation
equation.text= "F(x,y) = (y^3,3yx^2)";

