// A study: goal: simulate 3D effect using transparency
// and use keys to navigate the vector 

// vector field and geometry

function P(x,y,z) { return y; }
function Q(x,y,z) { return x; }
function R(x,y,z) { return 0; }

function curlx(x,y,z) { return 0; }
function curly(x,y,z) { return 0; }
function curlz(x,y,z) { return -2; }

valpha =0;
vbeta  =0;
vgamma =0;
depth=1; 

size = 2;   // number of vectors on positive coordinate axes
n = 6;      // number of points to draw the wheel
r = 70;     // radius of circle 

// parameters

alpha  = 0;        //  rotation angles
beta   = 0;      
gamma  = 0;
x_center  = 200; 
y_center  = 200;
z_center  = 200; 
red=0; green=0; blue=255; 
thick=5; 
count=0;
dgamma=0.1;  dbeta=0.1;  dalpha=0.01; 
dvgamma=0.1; dvbeta=0.1; dvalpha=0; 

_root.createEmptyMovieClip("field",1);   //  keep vector field seperate

onEnterFrame = function() { 
  keys(); 
  if (count==0) { vfield(); }
  count=1; 
  _root.clear();
  wheel(); 
}

function keys () {
  if(Key.isDown(Key.UP))        { clear(); gamma = gamma + dgamma; } 
  if(Key.isDown(Key.DOWN))      { clear(); gamma = gamma - dgamma; }
  if(Key.isDown(Key.LEFT))      { clear(); beta  = beta  + dbeta;  } 
  if(Key.isDown(Key.RIGHT))     { clear(); beta  = beta  - dbeta;  } 
  if(Key.isDown(Key.UP) and Key.isDown(Key.SHIFT))    { _root.field.clear(); vgamma = vgamma + dvgamma; vfield(); } 
  if(Key.isDown(Key.DOWN) and Key.isDown(Key.SHIFT))  { _root.field.clear(); vgamma = vgamma - dvgamma; vfield(); } 
  if(Key.isDown(Key.LEFT) and Key.isDown(Key.SHIFT))  { _root.field.clear(); vbeta  = vbeta + dvbeta; vfield(); } 
  if(Key.isDown(Key.RIGHT) and Key.isDown(Key.SHIFT)) { _root.field.clear(); vbeta  = vbeta - dvbeta; vfield(); } 
}


function wheel() {
  cosa = Math.cos(alpha); sina = Math.sin(alpha);
  cosb = Math.cos(beta);  sinb = Math.sin(beta);
  cosg = Math.cos(gamma); sing = Math.sin(gamma);

  x0 = 0; y0 = 0; z0 = 0; 
  curlxx=curlx(x0,y0,z0); 
  curlyy=curly(x0,y0,z0); 
  curlzz=curlz(x0,y0,z0); 
  curlxxx = cosva*cosvb*curlxx+cosvb*sinva*curlyy+sinvb*curlzz;
  curlyyy = (-cosvg*sinva-cosva*sinvb*sinvg)*curlxx+( cosva*cosvg-sinva*sinvb*sinvg)*curlyy+cosvb*sinvg*curlzz;
  curlzzz = (-cosva*cosvg*sinvb+sinva*sinvg)*curlxx+(-cosvg*sinva*sinvb-cosva*sinvg)*curlyy+cosvb*cosvg*curlzz;


  xx0 = cosa*cosb*x0+cosb*sina*y0+sinb*z0;
  yy0 = (-cosg*sina-cosa*sinb*sing)*x0+( cosa*cosg-sina*sinb*sing)*y0+cosb*sing*z0;
  zz0 = (-cosa*cosg*sinb+sina*sing)*x0+(-cosg*sina*sinb-cosa*sing)*y0+cosb*cosg*z0;


  x5 = 0; y5 = 0; z5 = 50;
  xx5 = cosa*cosb*x5+cosb*sina*y5+sinb*z5;
  yy5 = (-cosg*sina-cosa*sinb*sing)*x5+( cosa*cosg-sina*sinb*sing)*y5+cosb*sing*z5;
  zz5 = (-cosa*cosg*sinb+sina*sing)*x5+(-cosg*sina*sinb-cosa*sing)*y5+cosb*cosg*z5;

  rot = xx5*curlxxx+yy5*curlyyy+zz5*curlzzz;
  dalpha = rot/900; 

  x6 = 0; y6 = 0; z6 = 80;
  xx6 = cosa*cosb*x6+cosb*sina*y6+sinb*z6;
  yy6 = (-cosg*sina-cosa*sinb*sing)*x6+( cosa*cosg-sina*sinb*sing)*y6+cosb*sing*z6;
  zz6 = (-cosa*cosg*sinb+sina*sing)*x6+(-cosg*sina*sinb-cosa*sing)*y6+cosb*cosg*z6;

  x8 = 0; y8 = 0; z8 = 80;
  xx8 = cosa*cosb*x8+cosb*sina*y8+sinb*z8;
  yy8 = (-cosg*sina-cosa*sinb*sing)*x8+( cosa*cosg-sina*sinb*sing)*y8+cosb*sing*z8;
  zz8 = (-cosa*cosg*sinb+sina*sing)*x8+(-cosg*sina*sinb-cosa*sing)*y8+cosb*cosg*z8;


  red=255; green=0; blue=0;
  _root.lineStyle(7-zz8/50,red<<16^green<<8^blue,100);
  _root.moveTo(x_center+xx0,y_center+yy0);
  _root.lineTo(x_center+xx8,y_center+yy8);

  for (i=0; i<n; i++) {
    theta=2*Math.Pi*i/n; costheta=Math.cos(theta); sintheta=Math.sin(theta);  
    x1 = r*costheta; y1 = r*sintheta; z1 = z5;
    x7 = r*costheta; y7 = r*sintheta; z7 = z6;

    red  =(costheta+1)*255/2; 
    green=(sintheta+1)*255/2; 
    blue =0; 

    xx1 = cosa*cosb*x1+cosb*sina*y1+sinb*z1; 
    yy1 = (-cosg*sina-cosa*sinb*sing)*x1+( cosa*cosg-sina*sinb*sing)*y1+cosb*sing*z1; 
    zz1 = (-cosa*cosg*sinb+sina*sing)*x1+(-cosg*sina*sinb-cosa*sing)*y1+cosb*cosg*z1;

    xx7 = cosa*cosb*x7+cosb*sina*y7+sinb*z7; 
    yy7 = (-cosg*sina-cosa*sinb*sing)*x7+( cosa*cosg-sina*sinb*sing)*y7+cosb*sing*z7; 
    zz7 = (-cosa*cosg*sinb+sina*sing)*x7+(-cosg*sina*sinb-cosa*sing)*y7+cosb*cosg*z7;

    _root.lineStyle(thick,red<<16^green<<8^blue,30+(100-zz0)/2);
    _root.moveTo(x_center+xx5,y_center+yy5);
    _root.lineTo(x_center+xx1,y_center+yy1); 
    _root.lineTo(x_center+xx7,y_center+yy7); 
    _root.lineTo(x_center+xx8,y_center+yy8); 
    red=(costheta+1)*255/2; green=0; blue=(sintheta+1)*255/2;
  }

  if (beta>Math.Pi)   {beta=beta-2*Math.Pi; }
  if (beta<-Math.Pi)  {beta=beta+2*Math.Pi; }
  if (gamma>Math.Pi)  {gamma=gamma-2*Math.Pi; }
  if (gamma<-Math.Pi) {gamma=gamma+2*Math.Pi; }
  alpha=alpha+dalpha; if (alpha>2*Math.Pi) { alpha=alpha-2*Math.Pi; } 
}


//graph vector field
function vfield() {
cosva = Math.cos(valpha); sinva = Math.sin(valpha);
cosvb = Math.cos(vbeta);  sinvb = Math.sin(vbeta);
cosvg = Math.cos(vgamma); sinvg = Math.sin(vgamma);
  for (i=-size; i<=size; i++) {
     for (j=-size; j<=size; j++) {
        for(k=-size; k<=size; k++) {
            x1 = 55*i;
            y1 = 55*j;
            z1 = 55*k;
            pp= P(1.5*i, 1.5*-j, 1.5*k);
            qq= Q(1.5*i, 1.5*-j, 1.5*k);
            rr= R(1.5*i, 1.5*-j, 1.5*k);
            // ll = Math.sqrt(pp*pp+qq*qq+rr*rr);
            x2 = x1 + 10*pp;
            y2 = y1 + 10*qq;
            z2 = z1 + 10*rr;
            xx1 = x_center + cosva*cosvb*x1+cosvb*sinva*y1+sinvb*z1;
            yy1 = y_center + (-cosvg*sinva-cosva*sinvb*sinvg)*x1+( cosva*cosvg-sinva*sinvb*sinvg)*y1+cosvb*sinvg*z1;
            xx2 = x_center + cosva*cosvb*x2+cosvb*sinva*y2+sinvb*z2;
            yy2 = y_center + (-cosvg*sinva-cosva*sinvb*sinvg)*x2+( cosva*cosvg-sinva*sinvb*sinvg)*y2+cosvb*sinvg*z2;
            vec(xx1,yy1,xx2,yy2,2,0,0,255,z1);
         }
      }
   }
}


// draw vector
a=0.3; b=0.1;
function vec(xx1,yy1,xx2,yy2,thick,red,green,blue,zz1) {
    xx3 = xx1+(1-a)*(xx2-xx1); yy3=yy1+(1-a)*(yy2-yy1);
    xx4 = xx3+b*(yy1-yy2);     yy4=yy3+b*(xx2-xx1);
    xx5 = xx3-b*(yy1-yy2);     yy5=yy3-b*(xx2-xx1);

   _root.field.lineStyle(thick,red<<16^green<<8^blue,(100-zz1)/2);
   _root.field.moveTo(xx1,yy1); _root.field.lineTo(xx3,yy3);
   _root.field.moveTo(xx2,yy2); _root.field.lineTo(xx4,yy4);
   _root.field.lineTo(xx5,yy5); _root.field.lineTo(xx2,yy2);
}

