/*\
 *  This Flash actionscript file is part of a PITF project
 *  Copyright (C) 2004-2005  David Mahfouda and Oliver Knill, Harvard University
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

// vector field and geometry

function P(x,y,z) { return y+x; }
function Q(x,y,z) { return x; }
function R(x,y,z) { return x*z; }

function curlx(x,y,z) { return 0; }
function curly(x,y,z) { return -z; }
function curlz(x,y,z) { return -2; }
function div(x,y,z)   { s=1+x; return s; }
adaptrot = 1;
adaptdiv = 2000;


valpha =10; vbeta  =-60; vgamma =30;
valpha =0; vbeta  =-0; vgamma =0;
choice=2;   // 1 = div,  2 = curl 

size = 2;   // number of vectors on positive coordinate axes
n = 6;      // number of points to draw the wheel
r = 70;     // radius of circle 
ss = 60;    // size of box


// parameters

alpha  = 40;  beta   = 20;      gamma  = 100;
alpha  = 0;  beta   = 0;      gamma  = 0;
x_center  = 200; 
y_center  = 200;
z_center  = 200; 
red=0; green=0; blue=255; 
thick=2; 
count=0;
dgamma=0.1;  dbeta=0.1;  dalpha=0.01; 
dvgamma=0.1; dvbeta=0.1; dvalpha=0; 

_root.createEmptyMovieClip("field",1);   //  keep vector field seperate

onEnterFrame = function() { 
  keys(); 
  if (count==0) { vfield(); } count=1; 
  _root.clear();
  if (choice==2) { wheel();  }
  if (choice==1) { box();  }
}

function keys () {
  if(Key.isDown(Key.UP))        { clear(); gamma = gamma + dgamma; } 
  if(Key.isDown(Key.DOWN))      { clear(); gamma = gamma - dgamma; }
  if(Key.isDown(Key.LEFT))      { clear(); beta  = beta  + dbeta;  } 
  if(Key.isDown(Key.RIGHT))     { clear(); beta  = beta  - dbeta;  } 
  if(Key.isDown(Key.UP) and Key.isDown(Key.SHIFT))    { _root.field.clear(); vgamma = vgamma + dvgamma; vfield(); } 
  if(Key.isDown(Key.DOWN) and Key.isDown(Key.SHIFT))  { _root.field.clear(); vgamma = vgamma - dvgamma; vfield(); } 
  if(Key.isDown(Key.LEFT) and Key.isDown(Key.SHIFT))  { _root.field.clear(); vbeta  = vbeta + dvbeta; vfield(); } 
  if(Key.isDown(Key.RIGHT) and Key.isDown(Key.SHIFT)) { _root.field.clear(); vbeta  = vbeta - dvbeta; vfield(); } 
  if(Key.isDown(68)) { choice=1; }    // 68 is keycode for "d" for div
  if(Key.isDown(67)) { choice=2; }    // 82 is keycode for "c" for curl
}

expand = 0;
function box() {
        x0 = -gamma*30; y0 = -beta*30; z0 = 0;

        xx0 = cosva*cosvb*x0+cosvb*sinva*y0+sinvb*z0;
        yy0 = (-cosvg*sinva-cosva*sinvb*sinvg)*x0+( cosva*cosvg-sinva*sinvb*sinvg)*y0+cosvb*sinvg*z0;
        zz0 = (-cosva*cosvg*sinvb+sinva*sinvg)*x0+(-cosvg*sinva*sinvb-cosva*sinvg)*y0+cosvb*cosvg*z0;

        fielddiv=div(xx0,yy0,zz0);
        speed   = fielddiv/adaptdiv;
        expand  = expand + speed;
        expand1 = expand + 0.5;
        if (expand>1) { expand=0; }
        if (expand<0) { expand=1; }
        if (expand1>1) { expand1=expand1-1; }
        pp = ss*expand;

        cx=0; cy=0; cz=0;

        cxx1 = cosva*cosvb*(cx+pp)+cosvb*sinva*cy+sinvb*cz;
        cyy1 = (-cosvg*sinva-cosva*sinvb*sinvg)*(cx+pp)+( cosva*cosvg-sinva*sinvb*sinvg)*cy+cosvb*sinvg*cz;
        czz1 = (-cosva*cosvg*sinvb+sinva*sinvg)*(cx+pp)+(-cosvg*sinva*sinvb-cosva*sinvg)*cy+cosvb*cosvg*cz;

        cxx2 = cosva*cosvb*cx+cosvb*sinva*(cy+pp)+sinvb*cz;
        cyy2 = (-cosvg*sinva-cosva*sinvb*sinvg)*cx+( cosva*cosvg-sinva*sinvb*sinvg)*(cy+pp)+cosvb*sinvg*cz;
        czz2 = (-cosva*cosvg*sinvb+sinva*sinvg)*cx+(-cosvg*sinva*sinvb-cosva*sinvg)*(cy+pp)+cosvb*cosvg*cz;

        cxx3 = cosva*cosvb*cx+cosvb*sinva*cy+sinvb*(cz+pp);
        cyy3 = (-cosvg*sinva-cosva*sinvb*sinvg)*cx+( cosva*cosvg-sinva*sinvb*sinvg)*cy+cosvb*sinvg*(cz+pp);
        czz3 = (-cosva*cosvg*sinvb+sinva*sinvg)*cx+(-cosvg*sinva*sinvb-cosva*sinvg)*cy+cosvb*cosvg*(cz+pp);

        cxx4 = - cxx1; cyy4 = - cyy1; czz4 = - czz1; 
        cxx5 = - cxx2; cyy5 = - cyy2; czz5 = - czz2; 
        cxx6 = - cxx3; cyy6 = - cyy3; czz6 = - czz3; 

        cxx1=cxx1+x_center-beta*30; cyy1=cyy1+y_center-gamma*30; czz1=czz1+z_center;
        cxx2=cxx2+x_center-beta*30; cyy2=cyy2+y_center-gamma*30; czz2=czz2+z_center;
        cxx3=cxx3+x_center-beta*30; cyy3=cyy3+y_center-gamma*30; czz3=czz3+z_center;
        cxx4=cxx4+x_center-beta*30; cyy4=cyy4+y_center-gamma*30; czz4=czz4+z_center;
        cxx5=cxx5+x_center-beta*30; cyy5=cyy5+y_center-gamma*30; czz5=czz5+z_center;
        cxx6=cxx6+x_center-beta*30; cyy6=cyy6+y_center-gamma*30; czz6=czz6+z_center;

        _root.lineStyle (1,0xff0000,100*(1-expand/2));
        _root.moveTo (cxx1,cyy1);
        _root.lineTo (cxx2,cyy2);
        _root.lineTo (cxx4,cyy4);
        _root.lineTo (cxx5,cyy5);
        _root.lineTo (cxx1,cyy1);
        _root.lineStyle (1,0xff4400,100*(1-expand/2));
        _root.moveTo (cxx1,cyy1);
        _root.lineTo (cxx3,cyy3);
        _root.lineTo (cxx4,cyy4);
        _root.lineTo (cxx6,cyy6);
        _root.lineTo (cxx1,cyy1);
        _root.lineStyle (1,0xff8800,100*(1-expand/2));
        _root.moveTo (cxx2,cyy2);
        _root.lineTo (cxx3,cyy3);
        _root.lineTo (cxx5,cyy5);
        _root.lineTo (cxx6,cyy6);
        _root.lineTo (cxx2,cyy2);

        pp = ss*expand1;

        cxx1 = cosva*cosvb*(cx+pp)+cosvb*sinva*cy+sinvb*cz;
        cyy1 = (-cosvg*sinva-cosva*sinvb*sinvg)*(cx+pp)+( cosva*cosvg-sinva*sinvb*sinvg)*cy+cosvb*sinvg*cz;
        czz1 = (-cosva*cosvg*sinvb+sinva*sinvg)*(cx+pp)+(-cosvg*sinva*sinvb-cosva*sinvg)*cy+cosvb*cosvg*cz;

        cxx2 = cosva*cosvb*cx+cosvb*sinva*(cy+pp)+sinvb*cz;
        cyy2 = (-cosvg*sinva-cosva*sinvb*sinvg)*cx+( cosva*cosvg-sinva*sinvb*sinvg)*(cy+pp)+cosvb*sinvg*cz;
        czz2 = (-cosva*cosvg*sinvb+sinva*sinvg)*cx+(-cosvg*sinva*sinvb-cosva*sinvg)*(cy+pp)+cosvb*cosvg*cz;

        cxx3 = cosva*cosvb*cx+cosvb*sinva*cy+sinvb*(cz+pp);
        cyy3 = (-cosvg*sinva-cosva*sinvb*sinvg)*cx+( cosva*cosvg-sinva*sinvb*sinvg)*cy+cosvb*sinvg*(cz+pp);
        czz3 = (-cosva*cosvg*sinvb+sinva*sinvg)*cx+(-cosvg*sinva*sinvb-cosva*sinvg)*cy+cosvb*cosvg*(cz+pp);

        cxx4 = - cxx1; cyy4 = - cyy1; czz4 = - czz1;
        cxx5 = - cxx2; cyy5 = - cyy2; czz5 = - czz2;
        cxx6 = - cxx3; cyy6 = - cyy3; czz6 = - czz3;

        cxx1=cxx1+x_center-beta*30; cyy1=cyy1+y_center-gamma*30; czz1=czz1+z_center;
        cxx2=cxx2+x_center-beta*30; cyy2=cyy2+y_center-gamma*30; czz2=czz2+z_center;
        cxx3=cxx3+x_center-beta*30; cyy3=cyy3+y_center-gamma*30; czz3=czz3+z_center;
        cxx4=cxx4+x_center-beta*30; cyy4=cyy4+y_center-gamma*30; czz4=czz4+z_center;
        cxx5=cxx5+x_center-beta*30; cyy5=cyy5+y_center-gamma*30; czz5=czz5+z_center;
        cxx6=cxx6+x_center-beta*30; cyy6=cyy6+y_center-gamma*30; czz6=czz6+z_center;

        _root.lineStyle (1,0xff0000,100*(1-expand/2));
        _root.moveTo (cxx1,cyy1);
        _root.lineTo (cxx2,cyy2);
        _root.lineTo (cxx4,cyy4);
        _root.lineTo (cxx5,cyy5);
        _root.lineTo (cxx1,cyy1);
        _root.lineStyle (1,0xff4400,100*(1-expand/2));
        _root.moveTo (cxx1,cyy1);
        _root.lineTo (cxx3,cyy3);
        _root.lineTo (cxx4,cyy4);
        _root.lineTo (cxx6,cyy6);
        _root.lineTo (cxx1,cyy1);
        _root.lineStyle (1,0xff8800,100*(1-expand/2));
        _root.moveTo (cxx2,cyy2);
        _root.lineTo (cxx3,cyy3);
        _root.lineTo (cxx5,cyy5);
        _root.lineTo (cxx6,cyy6);
        _root.lineTo (cxx2,cyy2);

}


function wheel() {
  cosa = Math.cos(alpha); sina = Math.sin(alpha);
  cosb = Math.cos(beta);  sinb = Math.sin(beta);
  cosg = Math.cos(gamma); sing = Math.sin(gamma);

  x0 = 0; y0 = 0; z0 = 0; 
  curlxx=curlx(x0,y0,z0); 
  curlyy=curly(x0,y0,z0); 
  curlzz=curlz(x0,y0,z0); 
  curlxxx = cosva*cosvb*curlxx+cosvb*sinva*curlyy+sinvb*curlzz;
  curlyyy = (-cosvg*sinva-cosva*sinvb*sinvg)*curlxx+( cosva*cosvg-sinva*sinvb*sinvg)*curlyy+cosvb*sinvg*curlzz;
  curlzzz = (-cosva*cosvg*sinvb+sinva*sinvg)*curlxx+(-cosvg*sinva*sinvb-cosva*sinvg)*curlyy+cosvb*cosvg*curlzz;


  xx0 = cosa*cosb*x0+cosb*sina*y0+sinb*z0;
  yy0 = (-cosg*sina-cosa*sinb*sing)*x0+( cosa*cosg-sina*sinb*sing)*y0+cosb*sing*z0;
  zz0 = (-cosa*cosg*sinb+sina*sing)*x0+(-cosg*sina*sinb-cosa*sing)*y0+cosb*cosg*z0;


  x5 = 0; y5 = 0; z5 = 50;
  xx5 = cosa*cosb*x5+cosb*sina*y5+sinb*z5;
  yy5 = (-cosg*sina-cosa*sinb*sing)*x5+( cosa*cosg-sina*sinb*sing)*y5+cosb*sing*z5;
  zz5 = (-cosa*cosg*sinb+sina*sing)*x5+(-cosg*sina*sinb-cosa*sing)*y5+cosb*cosg*z5;

  rot = xx5*curlxxx+yy5*curlyyy+zz5*curlzzz;
  dalpha = rot/900; 

  x6 = 0; y6 = 0; z6 = 80;
  xx6 = cosa*cosb*x6+cosb*sina*y6+sinb*z6;
  yy6 = (-cosg*sina-cosa*sinb*sing)*x6+( cosa*cosg-sina*sinb*sing)*y6+cosb*sing*z6;
  zz6 = (-cosa*cosg*sinb+sina*sing)*x6+(-cosg*sina*sinb-cosa*sing)*y6+cosb*cosg*z6;

  x8 = 0; y8 = 0; z8 = 80;
  xx8 = cosa*cosb*x8+cosb*sina*y8+sinb*z8;
  yy8 = (-cosg*sina-cosa*sinb*sing)*x8+( cosa*cosg-sina*sinb*sing)*y8+cosb*sing*z8;
  zz8 = (-cosa*cosg*sinb+sina*sing)*x8+(-cosg*sina*sinb-cosa*sing)*y8+cosb*cosg*z8;


  red=255; green=0; blue=0;
  _root.lineStyle(2,red<<16^green<<8^blue,100);
  _root.moveTo(x_center+xx0,y_center+yy0);
  _root.lineTo(x_center+xx8,y_center+yy8);

  for (i=0; i<n; i++) {
    theta=2*Math.Pi*i/n; costheta=Math.cos(theta); sintheta=Math.sin(theta);  
    x1 = r*costheta; y1 = r*sintheta; z1 = z5;
    x7 = r*costheta; y7 = r*sintheta; z7 = z6;

    red  =(costheta+1)*255/2; 
    green=(sintheta+1)*255/2; 
    blue =0; 

    xx1 = cosa*cosb*x1+cosb*sina*y1+sinb*z1; 
    yy1 = (-cosg*sina-cosa*sinb*sing)*x1+( cosa*cosg-sina*sinb*sing)*y1+cosb*sing*z1; 
    zz1 = (-cosa*cosg*sinb+sina*sing)*x1+(-cosg*sina*sinb-cosa*sing)*y1+cosb*cosg*z1;

    xx7 = cosa*cosb*x7+cosb*sina*y7+sinb*z7; 
    yy7 = (-cosg*sina-cosa*sinb*sing)*x7+( cosa*cosg-sina*sinb*sing)*y7+cosb*sing*z7; 
    zz7 = (-cosa*cosg*sinb+sina*sing)*x7+(-cosg*sina*sinb-cosa*sing)*y7+cosb*cosg*z7;

    _root.lineStyle(2,red<<16^green<<8^blue,30+(100-zz0)/2);
    _root.moveTo(x_center+xx5,y_center+yy5);
    _root.lineTo(x_center+xx1,y_center+yy1); 
    _root.lineTo(x_center+xx7,y_center+yy7); 
    _root.lineTo(x_center+xx8,y_center+yy8); 
    red=(costheta+1)*255/2; green=0; blue=(sintheta+1)*255/2;
  }

  if (beta>Math.Pi)   {beta=beta-2*Math.Pi; }
  if (beta<-Math.Pi)  {beta=beta+2*Math.Pi; }
  if (gamma>Math.Pi)  {gamma=gamma-2*Math.Pi; }
  if (gamma<-Math.Pi) {gamma=gamma+2*Math.Pi; }
  alpha=alpha+dalpha; if (alpha>2*Math.Pi) { alpha=alpha-2*Math.Pi; } 
}


//graph vector field
function vfield() {
cosva = Math.cos(valpha); sinva = Math.sin(valpha);
cosvb = Math.cos(vbeta);  sinvb = Math.sin(vbeta);
cosvg = Math.cos(vgamma); sinvg = Math.sin(vgamma);
  for (i=-size; i<=size; i++) {
     for (j=-size; j<=size; j++) {
        for(k=-size; k<=size; k++) {
            x1 = 55*i;
            y1 = 55*j;
            z1 = 55*k;
            pp= P(1.5*i, 1.5*-j, 1.5*k);
            qq= Q(1.5*i, 1.5*-j, 1.5*k);
            rr= R(1.5*i, 1.5*-j, 1.5*k);
            // ll = Math.sqrt(pp*pp+qq*qq+rr*rr);
            x2 = x1 + 10*pp;
            y2 = y1 + 10*qq;
            z2 = z1 + 10*rr;
            xx1 = x_center + cosva*cosvb*x1+cosvb*sinva*y1+sinvb*z1;
            yy1 = y_center + (-cosvg*sinva-cosva*sinvb*sinvg)*x1+( cosva*cosvg-sinva*sinvb*sinvg)*y1+cosvb*sinvg*z1;
            xx2 = x_center + cosva*cosvb*x2+cosvb*sinva*y2+sinvb*z2;
            yy2 = y_center + (-cosvg*sinva-cosva*sinvb*sinvg)*x2+( cosva*cosvg-sinva*sinvb*sinvg)*y2+cosvb*sinvg*z2;
            vec(xx1,yy1,xx2,yy2,2,0,0,255,z1);
         }
      }
   }
}


// draw vector
a=0.3; b=0.1;
function vec(xx1,yy1,xx2,yy2,thick,red,green,blue,zz1) {
    xx3 = xx1+(1-a)*(xx2-xx1); yy3=yy1+(1-a)*(yy2-yy1);
    xx4 = xx3+b*(yy1-yy2);     yy4=yy3+b*(xx2-xx1);
    xx5 = xx3-b*(yy1-yy2);     yy5=yy3-b*(xx2-xx1);

   _root.field.lineStyle(thick,red<<16^green<<8^blue,(100-zz1)/2);
   _root.field.moveTo(xx1,yy1); _root.field.lineTo(xx3,yy3);
   _root.field.moveTo(xx2,yy2); _root.field.lineTo(xx4,yy4);
   _root.field.lineTo(xx5,yy5); _root.field.lineTo(xx2,yy2);
}

