//  David Mahfouda 2004
//  Oliver Knill, 2004
//  2D curl animation action script 

//vector functions
function P(x,y) { return exp(y,3); }
function Q(x,y) { return 3*exp(x,2)*y; }
function rot(x,y) { return 3*y*y-6*x; }

// preparations
x_center = 200;           // body center
y_center = 200;           // body center
nvec = 5;                 // number of vectors per half plane
rr = 50;                  // size of wheel
spacing = 37;             // spacing between vectors in field 
mathpi180 = Math.PI/180;  // a constant which often occurs
onethird = 2*Math.PI/3;   // dito
a=0.3;                    // length of head
b=0.1;                    // width of head
c=10;                     // shadow displacement
maxcurl=0;                // the maximal curl on the region
mincurl=0;                // the minimal curl on the region
sss1=0; 
sss2=0; 

// the actual timeline 
cursorinit();
soundinit(); 
textt();
axes();
vfield();
findmax(); 

onEnterFrame = function() {
     mousmove();
     cursorspin(fieldcurl);
}

// initiate sound
function soundinit() {
  wind=new Sound();
  wind.attachSound("wind"); 
  wind.setVolume(0); 
  wind.start(0, 999999); 
  wind1=new Sound();
  wind1.attachSound("reverse");   
  wind1.setVolume(0);  
  wind1.start(0, 999999); 

}

// initiates cursor
function cursorinit() {
  _root.createEmptyMovieClip("cursor",1);
}

//reads curl of vector field at mouse location
function mousmove() {
     xx = _xmouse - x_center;     
     yy = _ymouse - y_center;           
     fieldcurl = rot(xx,yy);
     curl.text = "Curl: " + fieldcurl;
     if (fieldcurl<0) {
       wind.setVolume(Math.floor(Math.abs(fieldcurl*sss1))); 
       wind1.setVolume(Math.floor(0));
     } else {
       wind.setVolume(Math.floor(0));
       wind1.setVolume(Math.floor(Math.abs(fieldcurl*sss2))); 
     }
}

//draw coordinate axes
function axes() {
     //y-axis
     _root.lineStyle(2,000000,30);
     _root.moveTo(x_center,20);
     _root.lineTo(x_center,380);
     vec0(x_center,18,x_center,0,2,0,0,0,30);
      //x-axis
      _root.moveTo(20, y_center);
      _root.lineTo(380, y_center);
     vec0(382,y_center,400,y_center,2,0,0,0,30);
}

// create text boxes to read curl
function textt () {
      _root.createTextField("curl", 0, 300, 370, 200, 30);
}

//graph vector field
function vfield() {
    for (i=-nvec; i<nvec; i++) {
        for (j=-nvec; j<nvec; j++) {
              // relative coordinates
              x1 = x_center + spacing*i;
              y1 = y_center + spacing*j;
              _root.moveTo(x1, y1);
              //defining the individual vectors
              pp= P(1.5*i, 1.5*(-j));
              qq= Q(1.5*i, 1.5*(-j));
              //finding the length of vector
              ll = leng(pp,qq);
              //scaling vectors
              x2 = x1 + scale(ll)*10*pp/ll;
              y2 = y1 + scale(ll)*10*qq/ll;
              //j's are negative because "down" is positive
              vec(x1,y1,x2,y2,1,255,0,0,100)
          }
      }
}

// find the maximum and minimum of the curl 
function findmax() {
    for (i=-nvec; i<nvec; i++) {
        for (j=-nvec; j<nvec; j++) {
              cc = rot(1.5*i, 1.5*(-j));
              if (cc>maxcurl) {maxcurl=cc;}
              if (cc<mincurl) {mincurl=cc;}
          }
      }
    sss1=Math.abs(1/maxcurl)/3;
    sss2=Math.abs(1/mincurl)/3;
}


// drawing vectors function with shadow
function vec(x1,y1,x2,y2,thick,red,green,blue,z) {
      x3=x1+(1-a)*(x2-x1); y3=y1+(1-a)*(y2-y1);
      x4=x3+b*(y1-y2);     y4=y3+b*(x2-x1);
      x5=x3-b*(y1-y2);     y5=y3-b*(x2-x1);
     _root.lineStyle(thick,red<<16^green<<8^blue,z);
     _root.moveTo(x1,y1);
     _root.lineTo(x3,y3);
     _root.moveTo(x2,y2);
     _root.lineTo(x4,y4);
     _root.lineTo(x5,y5);
     _root.lineTo(x2,y2);
     _root.lineStyle(thick,red<<16^green<<8^blue,20);
     _root.moveTo(x1+c,y1);
     _root.lineTo(x3+c,y3);
     _root.moveTo(x2+c,y2);
     _root.lineTo(x4+c,y4);
     _root.lineTo(x5+c,y5);
     _root.lineTo(x2+c,y2);
}

// drawing vectors function without shadow
function vec0(x1,y1,x2,y2,thick,red,green,blue,z) {
      x3=x1+(1-a)*(x2-x1); y3=y1+(1-a)*(y2-y1);
      x4=x3+b*(y1-y2);     y4=y3+b*(x2-x1);
      x5=x3-b*(y1-y2);     y5=y3-b*(x2-x1);
     _root.lineStyle(thick,red<<16^green<<8^blue,z);
     _root.moveTo(x1,y1);
     _root.lineTo(x3,y3);
     _root.moveTo(x2,y2);
     _root.lineTo(x4,y4);
     _root.lineTo(x5,y5);
     _root.lineTo(x2,y2);
}



//arctan scaling function
function scale(number) { return 2*Math.atan(number/100); }


//exponent function
function exp(base,n) {
    if (n == 0) { return 1; } else { return exp(base,n-1)*base; }
}

//length function
function leng(x,y) { return Math.sqrt(0.0001+x*x + y*y); }

phi = 0
function cursorspin(curl) {
	Mouse.hide();
	cx = _xmouse; cy = _ymouse;
	speed = curl/120000;
        phi=phi+speed; 
	cursor.clear();
	pp1 = rr*Math.cos(phi);
	qq1 = rr*Math.sin(phi);
	pp2 = rr*Math.cos(phi + onethird);
	qq2 = rr*Math.sin(phi + onethird);
	pp3 = rr*Math.cos(phi - onethird);
	qq3 = rr*Math.sin(phi - onethird);

	cursor.lineStyle (2,0x00ff00,100);
	cursor.moveTo (cx+pp1,cy+qq1);
	cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0x00ff00,20);
        cursor.moveTo (cx+pp1+c,cy+qq1+c);
        cursor.lineTo (cx+c,cy+c);

	cursor.lineStyle (2,0xff0000,100);
	cursor.moveTo (cx+pp2,cy+qq2);
	cursor.lineTo (cx,cy);
	cursor.lineStyle (2,0xff0000,20);
	cursor.moveTo (cx+pp2+c,cy+qq2+c);
	cursor.lineTo (cx+c,cy+c);

	cursor.lineStyle (2,0x0000ff,100);
	cursor.moveTo (cx+pp3,cy+qq3);
	cursor.lineTo (cx,cy);
	cursor.lineStyle (2,0x0000ff,20);
	cursor.moveTo (cx+pp3+c,cy+qq3+c);
	cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0xff00ff,100);
        cursor.moveTo (cx-pp1,cy-qq1);
        cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0xff00ff,20);
        cursor.moveTo (cx-pp1+c,cy-qq1+c);
        cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0x00ffff,100);
        cursor.moveTo (cx-pp2,cy-qq2);
        cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0x00fffff,20);
        cursor.moveTo (cx-pp2+c,cy-qq2+c);
        cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0xffff00,100);
        cursor.moveTo (cx-pp3,cy-qq3);
        cursor.lineTo (cx,cy);
        cursor.lineStyle (2,0xffff00,20);
        cursor.moveTo (cx-pp3+c,cy-qq3+c);
        cursor.lineTo (cx+c,cy+c);

        cursor.lineStyle (2,0xeeeeee,100);
        cursor.moveTo (cx+pp1,cy+qq1);
        cursor.lineTo (cx-pp3,cy-qq3);
        cursor.lineTo (cx+pp2,cy+qq2);
        cursor.lineTo (cx-pp1,cy-qq1);
        cursor.lineTo (cx+pp3,cy+qq3);
        cursor.lineTo (cx-pp2,cy-qq2);
        cursor.lineTo (cx+pp1,cy+qq1);
        cursor.lineStyle (2,0xeeeeee,20);
        cursor.moveTo (cx+pp1+c,cy+qq1+c);
        cursor.lineTo (cx-pp3+c,cy-qq3+c);
        cursor.lineTo (cx+pp2+c,cy+qq2+c);
        cursor.lineTo (cx-pp1+c,cy-qq1+c);
        cursor.lineTo (cx+pp3+c,cy+qq3+c);
        cursor.lineTo (cx-pp2+c,cy-qq2+c);
        cursor.lineTo (cx+pp1+c,cy+qq1+c);
}


//show vector field equation
//root.createTextField("equation",1, 10, 20, 300, 30);
//print equation
//equation.text= "F(x,y) = (y^3,3yx^2)";

