// spiders by Adam Bowman. It is a nice template which shows how
// to animate independent objects in action script 
// laser vector on freaking spiders by Oliver Knill, May 16, 2005 for PITF presentation

// this  2 functions by Robert Penner
Math.easeInOutQuad = function (t, b, c, d){ if ((t/=d/2) <1) return c/2*t*t + b; return -c/2 * ((--t)*(t-2)-1) + b; };
Math.fixAngle      = function (angle) { angle %= 360; return (angle < 0) ? angle + 360 : angle; };

numWalkers=10;     // number of spiders
stride=50;         // geometry of spiders 
legHeight=8;
buffer=50;
stepHeight=6;
wait=0;            // frames between steps

walkCycle=new Array({leg:"R2",length:35},
                    {leg:"L1",length:25},
                    {leg:"L3",length:30},
                    {leg:"R4",length:25},
                    {leg:"R1",length:25},
                    {leg:"L2",length:35},
                    {leg:"R3",length:30},
                    {leg:"L4",length:25}); 
numLegs = walkCycle.length;
var legAngle = 360/(2+_root.numLegs);
var x1dead=1000; y1dead=1000; x2dead=2000; y2dead=1000;  // a line outside the battlefield


// create the spiders 

for(i=1;i<=_root.numWalkers;i++){
   _root.createEmptyMovieClip("body"+i,depth++);
   for(j=0;j<_root.numLegs;j++){
      _root["body"+i].createEmptyMovieClip(_root.walkCycle[j].leg,depth++);
      _root["body"+i][_root.walkCycle[j].leg].length=_root.walkCycle[j].length;
   }
   _root["body"+i]._x=Math.random()*Stage.width; 
   _root["body"+i]._y=Math.random()*Stage.height;
   _root["body"+i].angle=_root["body"+i]._rotation=Math.random()*360;
   _root["body"+i].alive=true; 

   _root["body"+i].resetMove=function(){
   for(j=1;j<=(_root.numLegs/2);j++){
     delete this["R"+j].onEnterFrame;
     delete this["L"+j].onEnterFrame;
     this["R"+j].beginX=false;
     this["L"+j].beginX=false;
     this["R"+j].time=0;
     this["L"+j].time=0;
   }
   this.setLegs();
   };

   _root["body"+i].setLegs=function(){
   for(j=1;j<=(_root.numLegs/2);j++){
     this["R"+j].shadow_x=this["R"+j].x=this._x-(Math.sin((this.angle-90+(legAngle*j))*(Math.PI/180))*this["R"+j].length);
        this["R"+j].shadow_y=this["R"+j].y=this._y+(Math.cos((this.angle-90+(legAngle*j))*(Math.PI/180))*this["R"+j].length);
        this["L"+j].shadow_x=this["L"+j].x=this._x+(Math.sin((this.angle+90-(legAngle*j))*(Math.PI/180))*this["L"+j].length);
        this["L"+j].shadow_y=this["L"+j].y=this._y-(Math.cos((this.angle+90-(legAngle*j))*(Math.PI/180))*this["L"+j].length);
     }
   }; 

   _root["body"+i].setLegs();
   _root["body"+i].onEnterFrame = walk;
   _root["body"+i].duration     = 9 +(int(Math.Random()*4));
   _root["body"+i].angleSpeed   = 20+(int(Math.Random()*10));
}

//  move the spiders 
function move(){
    if(!this.beginX){
      this.beginX=this.shadow_x;
      this.changeX=this.targetX-this.beginX;
      this.beginY=this.shadow_y;
      this.changeY=this.targetY-this.beginY;
    }
    this.shadow_x=Math.easeInOutQuad(this.time++,this.beginX,this.changeX,this._parent.duration);
    this.shadow_y=Math.easeInOutQuad(this.time,this.beginY,this.changeY,this._parent.duration);
    this.footHeight = _root.stepHeight*Math.sin((this.time/this._parent.duration)*Math.PI);
    this.x = this.shadow_x;
    this.y = this.shadow_y-this.footHeight;
    if (this.time>this._parent.duration){
         this.beginX=false;
         this.time=0;
         delete this.onEnterFrame;
    }
};

function walk(){
   // check whether hit by laser beam
   xx = this._x; yy= this._y; 
   disttolaserbeam = Math.abs((xx-x1dead)*(x2dead-x1dead) + (yy-y1dead)*(y2dead-y1dead));
   if (disttolaserbeam<3) { this.alive=false; }

   // check whether boundary is reached
   if(this._x>(Stage.width+_root.buffer)){
    this._x=-_root.buffer/1.5;
    this.resetMove();
   }
   if(this._x<-_root.buffer){
    this._x=Stage.width+(_root.buffer/1.5);
    this.resetMove();
   }
   if(this._y>(Stage.height+_root.buffer)){
    this._y=-(_root.buffer/1.5); 
    this.resetMove();
   }
   if(this._y<-_root.buffer){
    this._y=Stage.height+(_root.buffer/1.5);
    this.resetMove();
   }
   var totX;
   var totY;
   for(i=1;i<=(_root.numLegs/2);i++){
      totX+=this["L"+i].shadow_x;
      totY+=this["L"+i].shadow_y;
      totX+=this["R"+i].shadow_x;
      totY+=this["R"+i].shadow_y;
   }
   this._x=totX/_root.numLegs;
   this._y=totY/_root.numLegs;
   
   //rear coordinates
   var aveX1 = (this.L4.shadow_x + this.R4.shadow_x)/2;
   var aveY1 = (this.L4.shadow_y + this.R4.shadow_y)/2;
   var bodyAngle=Math.atan2((this._y-aveY1),(this._x-aveX1))+Math.PI;
   var cosbodyangle=Math.cos(bodyAngle);
   var sinbodyangle=Math.sin(bodyAngle);
   this.rear_x  = this._x + 18/2*cosbodyangle;
   this.rear_y  = this._y + 18/2.5*sinbodyangle;  
   this.rear2_x = this._x + 25/2*cosbodyangle;
   this.rear2_y = this._y + 25/2.5*sinbodyangle;  
  
   if (this.counter==_root.wait){
    var currLeg=_root.walkCycle[this.leg].leg;
    var legLength=_root.walkCycle[this.leg].length;

    //randomly change direction
    if ((int(Math.random()*8)+1 == 8)&&(currLeg.charAt(1)=="1")){
       (Math.round(Math.random())) ? this.angle-=this.angleSpeed : this.angle+=this.angleSpeed;
         this.angle = Math.fixAngle(this.angle); 
    }
    (this.leg<(_root.numLegs-1)) ? this.leg++ : this.leg=0;
    (currLeg.charAt(0)=="R") ? this.side=-1 : this.side=1;
    var legStride = _root.stride - ((currLeg.charAt(1))-1)*(_root.stride/(_root.numLegs/3));
    var dest_x=this._x+(Math.cos(this.angle*(Math.PI/180))*(legStride));
      var dest_y=this._y+(Math.sin(this.angle*(Math.PI/180))*(legStride));
    this[currLeg].targetX=dest_x+(this.side*(Math.sin(this.angle*(Math.PI/180))*legLength));
      this[currLeg].targetY=dest_y-(this.side*(Math.cos(this.angle*(Math.PI/180))*legLength));
    this[currLeg].onEnterFrame = move;
   }
   this.counter=0; 
   // (this.counter<_root.wait) ? this.counter++ : this.counter = 0;
};

// drawing vectors function without shadow, from GPLd Mahfouda-Knill code
c=10;                     // shadow displacement
d=3;                      // number of strokes
a=0.4;                    // length of head
b=0.1;                    // width of head

function vec(x1,y1,x2,y2,thick,red,green,blue,z) {
   _root.lineStyle(thick,red<<16^(green+255)<<8^blue,z);
   x3=x1+(1-a)*(x2-x1); y3=y1+(1-a)*(y2-y1);
   _root.moveTo(x1,y1); _root.lineTo(x3,y3); 
   _root.lineStyle(thick,100<<16^100<<8^100,20);
   _root.moveTo(x1+c,y1); _root.lineTo(x3+c,y3);
   for (j=0; j<d; j++) {
      x4=x3+b*(y1-y2)*j/d;     y4=y3+b*(x2-x1)*j/d;
      x5=x3-b*(y1-y2)*j/d;     y5=y3-b*(x2-x1)*j/d;
     _root.lineStyle(thick,red<<16^(green+255*j/d)<<8^blue,z);
     _root.moveTo(x2,y2); _root.lineTo(x4,y4);
     _root.lineTo(x5,y5); _root.lineTo(x2,y2);
     _root.lineStyle(thick,100<<16^100<<8^100,20);
     _root.moveTo(x2+c,y2); _root.lineTo(x4+c,y4);
     _root.lineTo(x5+c,y5); _root.lineTo(x2+c,y2);
  }
}

function laser(x1,y1,x2,y2,thick,red,green,blue,z) {
   _root.lineStyle(thick,red<<16^(green+255)<<8^blue,z);
   _root.moveTo(x1,y1); _root.lineTo(x2,y2);
}


onEnterFrame = function(){
  _root.clear();
  for(i=1;i<=_root.numWalkers;i++){
   if (_root["body"+i].alive) {
     _root.lineStyle(8, 0xffff00, 20);
     _root.moveTo(_root["body"+i]._x, _root["body"+i]._y);
     _root.lineTo(_root["body"+i]._x+.5, _root["body"+i]._y);   
     _root.lineStyle(13, 0x888888, 20);
     _root.moveTo(_root["body"+i].rear_x, _root["body"+i].rear_y);
     _root.lineTo(_root["body"+i].rear2_x, _root["body"+i].rear2_y);   
     _root.lineStyle(2, 0x888888, 25);

     //shadow
     for(j=1;j<=(_root.numLegs/2);j++){
        _root.moveTo(_root["body"+i]["R"+j].shadow_x, _root["body"+i]["R"+j].shadow_y);
        _root.lineTo(_root["body"+i]._x, _root["body"+i]._y);
        _root.moveTo(_root["body"+i]["L"+j].shadow_x, _root["body"+i]["L"+j].shadow_y);
        _root.lineTo(_root["body"+i]._x,_root["body"+i]._y);  
     }

     // legs 
     _root.lineStyle(1, 0x0000ff, 100);
     for(j=1;j<=(_root.numLegs/2);j++){
        _root.moveTo(_root["body"+i]["R"+j].x, _root["body"+i]["R"+j].y);
        _root.curveTo(_root["body"+i]["R"+j].x, _root["body"+i]["R"+j].y-15, _root["body"+i]._x, _root["body"+i]._y-_root.legHeight);
        _root.moveTo(_root["body"+i]["L"+j].x, _root["body"+i]["L"+j].y);
       _root.curveTo(_root["body"+i]["L"+j].x, _root["body"+i]["L"+j].y-15, _root["body"+i]._x, _root["body"+i]._y-_root.legHeight);
     }

     // vector
     l = 25+2*Math.random(); 
     x1=_root["body"+i].rear_x;  y1=_root["body"+i].rear_y-_root.legHeight;   
     x2=_root["body"+i].rear2_x; y2=_root["body"+i].rear2_y-_root.legHeight;
     vec(x1,y1,x1-l*(x2-x1),y2-l*(y2-y1),1,255,0,0,100);

     // laser  and publish deadly laser line
     if (l>26.9) {
       laser(x1,y1,x1-5*l*(x2-x1),y2-5*l*(y2-y1),1,255,255,0,100);
       x1dead=x1; y1dead=y1; x2dead=x2; y2dead=y2; 
     }

     // middle body
     _root.lineStyle(7, 0xffaa00, 100);
     _root.moveTo(_root["body"+i]._x, _root["body"+i]._y-_root.legHeight);
     _root.lineTo(_root["body"+i]._x+.5, _root["body"+i]._y-_root.legHeight);   

     // rear body
     _root.lineStyle(10, 0xff0000, 100);
     _root.moveTo(x1,y1); _root.lineTo(x2,y2);    
  }
 }
 x1dead=1000; y1dead=1000; x2dead=2000; y2dead=1000;  // put line again outside the battlefield
};
