// A study: visualizing surfaces

alpha  = 0.0;       //  rotation angles
beta   = 0.4;      
gamma  = 0.0;
x_center  = 200;    // center of picture
y_center  = 200;
z_center  = 200; 
nu = 10;            // number of u divisions
nv = 10;            // number of v divisions
 r = 100;           // size of surface
thick=2; 
dgamma=0.1; dbeta=0.1; dalpha=0.1; 

onEnterFrame = function() { 
  _root.clear(); 
  keys(); 
  surface(); 
}

function keys () {
  if(Key.isDown(Key.UP))        { clear(); gamma = gamma + dgamma; } 
  if(Key.isDown(Key.DOWN))      { clear(); gamma = gamma - dgamma; }
  if(Key.isDown(Key.LEFT))      { clear(); beta  = beta  + dbeta;  } 
  if(Key.isDown(Key.RIGHT))     { clear(); beta  = beta  - dbeta;  } 
  if(Key.isDown(Key.ENTER))     { clear(); alpha = alpha + dalpha; }
  if(Key.isDown(Key.BACKSPACE)) { clear(); alpha = alpha - dalpha; } 
  cosa = Math.cos(alpha); sina = Math.sin(alpha);
  cosb = Math.cos(beta);  sinb = Math.sin(beta);
  cosg = Math.cos(gamma); sing = Math.sin(gamma);
  A=cosa*cosb;                   B=cosb*sina;                   C=sinb;
  D=(-cosg*sina-cosa*sinb*sing); E=( cosa*cosg-sina*sinb*sing); F=cosb*sing;
  G=(-cosa*cosg*sinb+sina*sing); H=(-cosg*sina*sinb-cosa*sing); II=cosb*cosg;
}

function surface() {
  for (i=0; i<nu; i++) {
    u1 = i*2*Math.Pi/nu;  u2 = (i+1)*2*Math.Pi/nu; u3 = u2; 
    cosu1 = Math.cos(u1); sinu1 = Math.sin(u1); 
    cosu2 = Math.cos(u2); sinu2 = Math.sin(u2); 
    cosu3 = cosu2;        sinu3 = sinu2; 
    for (j=0; j<nv; j++) {
      v1 = j*Math.Pi/nv; v2 = v1; v3 = (j+1)*Math.Pi/nv; 

      cosv1 = Math.cos(v1); sinv1 = Math.sin(v1); 
      cosv2 = cosv1;        sinv2 = sinv1; 
      cosv3 = Math.cos(v3); sinv3 = Math.sin(v3); 

      x1 = r*cosu1*sinv1;  y1 = r*sinu1*sinv1; z1 = r*cosv1; 
      x2 = r*cosu2*sinv2;  y2 = r*sinu2*sinv2; z2 = r*cosv2; 
      x3 = r*cosu3*sinv3;  y3 = r*sinu3*sinv3; z3 = r*cosv3; 

      xx1 = A*x1+B*y1+C*z1; yy1 = D*x1+E*y1+F*z1; zz1 = G*x1+H*y1+II*z1;
      xx2 = A*x2+B*y2+C*z2; yy2 = D*x2+E*y2+F*z2; zz2 = G*x2+H*y2+II*z2;
      xx3 = A*x3+B*y3+C*z3; yy3 = D*x3+E*y3+F*z3; zz3 = G*x3+H*y3+II*z3;

      red  = 255*u1/(2*Math.Pi); green = 255*v1/Math.Pi; blue = 255*v1/Math.Pi; 
      thick=1;
      _root.lineStyle(thick,red<<16^green<<8^blue,50-50*zz1/r);
      _root.moveTo(x_center+xx1,y_center+yy1);
      _root.lineTo(x_center+xx2,y_center+yy2); 
      _root.lineTo(x_center+xx3,y_center+yy3); 
    }
  }
  if (beta>2*Math.Pi)   {beta=beta-2*Math.Pi;   }
  if (beta<-2*Math.Pi)  {beta=beta+2*Math.Pi;   }
  if (gamma>2*Math.Pi)  {gamma=gamma-2*Math.Pi; }
  if (gamma<-2*Math.Pi) {gamma=gamma+2*Math.Pi; }
}

