/*\
 *  Study to visualize parametrized surfaces
 *  Last editing: May 16, 2005  before PITF workshop
 *  This Flash actionscript file is part of a PITF project
 *  Copyright (C) 2004-2005,  Oliver Knill, Harvard University
 *  spin off of PITF project Summer 2004 with Presidential IT fellow 
 *  David Mahfouda. Visit website www.math.harvard.edu/~knill/pitf
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

//  some global variables 

alpha  = 0.0;       //  rotation angles
beta   = 0.4;      
gamma  = 0.0;
dgamma=0.3;         //  increments for rotation
dbeta=0.3; 
dalpha=0.3; 
x_center  = 200;    // center of picture
y_center  = 200;
z_center  = 200; 
nu = 13;            // number of u divisions
nv = 13;            // number of v divisions
 r = 50;            // size of surface
thick=1;            // thickness of lines
alpha1 = 0;         // parameter 1 for surface
dalpha1 = 0.3; 
alpha2 = 0;         // parameter 2 for surface
dalpha2 = 0.3; 
alpha3 = 0;         // parameter 3 for surface
dalpha3 = 0.3; 

twopi = 2*Math.PI;  // optimization attempts
oneovertwopi = 1/twopi; 
twopiovernu  = twopi/nu; 

// timeline main procedure 

onEnterFrame = function() { 
  _root.clear(); 
  keys(); 
  surface(); 
  fixangles(); 
}

// keep track of user input and adjust parameters 

function keys () {
  if(Key.isDown(Key.UP))        { clear(); gamma = gamma + dgamma; } 
  if(Key.isDown(Key.DOWN))      { clear(); gamma = gamma - dgamma; }
  if(Key.isDown(Key.LEFT))      { clear(); beta  = beta  + dbeta;  } 
  if(Key.isDown(Key.RIGHT))     { clear(); beta  = beta  - dbeta;  } 
  if(Key.isDown(Key.ENTER))     { clear(); alpha = alpha + dalpha; }
  if(Key.isDown(Key.BACKSPACE)) { clear(); alpha = alpha - dalpha; } 
  if(Key.isDown(65)) { clear(); alpha1=alpha1+dalpha1; }     //   key a parameter 1 
  if(Key.isDown(83)) { clear(); alpha2=alpha2+dalpha2; }     //   key s parameter 2 
  if(Key.isDown(68)) { clear(); alpha3=alpha3+dalpha3; }     //   key d parameter 3 
  if(Key.isDown(67)) { clear(); nu= 8; nv=8}                 //   key c low resolution 
  if(Key.isDown(88)) { clear(); nu=13; nv=13}                //   key x middle resolution 
  if(Key.isDown(90)) { clear(); nu=25; nv=25}                //   key z high resolution 
  cosa = Math.cos(alpha); sina = Math.sin(alpha);
  cosb = Math.cos(beta);  sinb = Math.sin(beta);
  cosg = Math.cos(gamma); sing = Math.sin(gamma);
  A=cosa*cosb;                   B=cosb*sina;                   C=sinb;
  D=(-cosg*sina-cosa*sinb*sing); E=( cosa*cosg-sina*sinb*sing); F=cosb*sing;
  G=(-cosa*cosg*sinb+sina*sing); H=(-cosg*sina*sinb-cosa*sing); II=cosb*cosg;
  oneovertwopi = 1/twopi; 
  twopiovernu  = twopi/nu; 
}

// draw the surface 

function surface() {
  aa = 2*Math.cos(alpha1);
  for (i=0; i<nu; i++) {
    u1 = i*twopiovernu;  u2 = (i+1)*twopiovernu; u3 = u2; 
    cosu1 = Math.cos(u1); sinu1 = Math.sin(u1); 
    cosu2 = Math.cos(u2); sinu2 = Math.sin(u2); 
    cosu3 = cosu2;        sinu3 = sinu2; 
    b1 = Math.sin(u1); b2 = Math.sin(u2); b3 = Math.sin(u3);
    rr1 = r*(1+Math.sin(alpha2))*(1+b1*Math.sin(alpha3));
    rr2 = r*(1+Math.sin(alpha2))*(1+b2*Math.sin(alpha3));
    rr3 = r*(1+Math.sin(alpha2))*(1+b3*Math.sin(alpha3));

    for (j=0; j<nv; j++) {
      v1 = j*twopiovernu; v2 = v1; v3 = (j+1)*twopiovernu; 

      cosv1 = Math.cos(v1); sinv1 = Math.sin(v1); 
      cosv2 = cosv1;        sinv2 = sinv1; 
      cosv3 = Math.cos(v3); sinv3 = Math.sin(v3); 

      // here are the definition of the parametrized surface
      x1 = rr1*(aa+cosv1)*cosu1;  y1 = rr1*(aa+cosv1)*sinu1; z1 = rr1*sinv1; 
      x2 = rr2*(aa+cosv2)*cosu2;  y2 = rr2*(aa+cosv2)*sinu2; z2 = rr2*sinv2; 
      x3 = rr3*(aa+cosv3)*cosu3;  y3 = rr3*(aa+cosv3)*sinu3; z3 = rr3*sinv3; 

      xx1 = A*x1+B*y1+C*z1; yy1 = D*x1+E*y1+F*z1; zz1 = G*x1+H*y1+II*z1;
      xx2 = A*x2+B*y2+C*z2; yy2 = D*x2+E*y2+F*z2; zz2 = G*x2+H*y2+II*z2;
      xx3 = A*x3+B*y3+C*z3; yy3 = D*x3+E*y3+F*z3; zz3 = G*x3+H*y3+II*z3;

      red  = 255*v1*oneovertwopi; green = 255*u1*oneovertwopi; blue = 255*v1*oneovertwopi; 
      _root.lineStyle(thick,red<<16^green<<8^blue,50-50*zz1/r);
      _root.moveTo(x_center+xx1,y_center+yy1);
      _root.lineTo(x_center+xx2,y_center+yy2); 
      _root.lineTo(x_center+xx3,y_center+yy3); 
    }
  }
}

// this is not really necessary, would work without that 

function fixangles() {
  if (alpha1>twopi)  {alpha1-=twopi; } if (alpha1<-twopi) {alpha1 +=twopi   }
  if (alpha2>twopi)  {alpha2-=twopi; } if (alpha2<-twopi) {alpha2 +=twopi   }
  if (alpha3>twopi)  {alpha3-=twopi; } if (alpha3<-twopi) {alpha3 +=twopi   }
  if (alpha>twopi)   {alpha-=twopi;  } if (alpha<-twopi)  {alpha +=twopi    }
  if (beta>twopi)    {beta-=twopi;   } if (beta<-twopi)   {beta +=twopi     }
  if (gamma>twopi)   {gamma-=twopi;  } if (gamma<-twopi)  {gamma +=twopi    }
}

