// A test to turn a vector with keys
alpha     = 0; beta  = 0.4;       gamma = 0;
x_center  = 200; y_center  = 200; z_center  = 200; 
n = 30; r = 30; red=0; green=0; blue=255; thick=5; 
dgamma=0.01; dbeta=0.01; dalpha=0.001; 
onEnterFrame = function() { _root.clear(); vector(); }

function vector() {
  cosa = Math.cos(alpha); sina = Math.sin(alpha);
  cosb = Math.cos(beta);  sinb = Math.sin(beta);
  cosg = Math.cos(gamma); sing = Math.sin(gamma);

  x0 = 0; y0 = 0; z0 = -170; 
  xx0 = cosa*cosb*x0+cosb*sina*y0+sinb*z0;
  yy0 = (-cosg*sina-cosa*sinb*sing)*x0+( cosa*cosg-sina*sinb*sing)*y0+cosb*sing*z0;
  zz0 = (-cosa*cosg*sinb+sina*sing)*x0+(-cosg*sina*sinb-cosa*sing)*y0+cosb*cosg*z0;

for (i=0; i<n; i++) {
    theta=6.28319*i/n; costheta=Math.cos(theta); sintheta=Math.sin(theta);
    x1 = r*costheta*2; y1 = r*sintheta*2; z1 = -100;
    x2 = r*costheta;   y2 = r*sintheta;   z2 =  100;

    red  =(costheta+1)*255/2;
    green=(sintheta+1)*255/2;
    blue =0;

    xx1 = cosa*cosb*x1+cosb*sina*y1+sinb*z1;
    yy1 = (-cosg*sina-cosa*sinb*sing)*x1+( cosa*cosg-sina*sinb*sing)*y1+cosb*sing*z1;
    zz1 = (-cosa*cosg*sinb+sina*sing)*x1+(-cosg*sina*sinb-cosa*sing)*y1+cosb*cosg*z1;

    xx2 = cosa*cosb*x2+cosb*sina*y2+sinb*z2;
    yy2 = (-cosg*sina-cosa*sinb*sing)*x2+( cosa*cosg-sina*sinb*sing)*y2+cosb*sing*z2;
    zz2 = (-cosa*cosg*sinb+sina*sing)*x2+(-cosg*sina*sinb-cosa*sing)*y2+cosb*cosg*z2;

    _root.lineStyle(thick,red<<16^green<<8^blue,30+(100-zz2)/2);
    _root.moveTo(x_center+xx1,y_center+yy1);
    _root.lineTo(x_center+xx2,y_center+yy2);
    red=(costheta+1)*122.5; green=0; blue=(sintheta+1)*122.5;

    _root.lineStyle(thick,red<<16^green<<8^blue,30+(100-zz1)/2);
    _root.moveTo(x_center+xx0,y_center+yy0);
    _root.lineTo(x_center+xx0+1.5*(xx1-xx0),y_center+yy0+1.5*(yy1-yy0));
  }

  beta=beta+dbeta; gamma=gamma+dgamma;
  dbeta=dbeta+0.0003*Math.random(); 
  dgamma=dgamma+0.0003*Math.random(); 
  if (beta>3.14159)   {beta=beta-2*Math.Pi; }
  if (beta<-3.14159)  {beta=beta+2*Math.Pi; }
  if (gamma>3.14159)  {gamma=gamma-2*Math.Pi; }
  if (gamma<-3.14159) {gamma=gamma+2*Math.Pi; }
}
