// visualization test vector fields
// oliver knill, august 2004

function P(x,y){ return(-(y-200)); }
function Q(x,y){ return((x-200));  }

n=8;
boundary=10;
xsize=400;
ysize=400;
dx=(xsize-2*boundary)/n; 
dy=(ysize-2*boundary)/n; 
var eps=0.000001; 
var t=0;
var dt=3;
var eps=0.1; 

for(i=0;i<=n;i++){
for(j=0;j<=n;j++){
   _root.createEmptyMovieClip("field"+i+j,depth++);
   _root["field"+i+j]._x=boundary+dx*i; 
   _root["field"+i+j]._y=boundary+dy*j;
   _root["field"+i+j]._t=10*Math.random();
}
}

//_root["mouse"].x=_xMouse; 
//_root["mouse"].y=_yMouse; 

// draw vector
function vec(x1,y1,x2,y2,thick,red,green,blue,z) {
    a=0.3; b=0.1;
    x3=x1+(1-a)*(x2-x1); y3=y1+(1-a)*(y2-y1);
    x4=x3+b*(y1-y2);     y4=y3+b*(x2-x1);
    x5=x3-b*(y1-y2);     y5=y3-b*(x2-x1);
   _root.lineStyle(thick,red<<16^green<<8^blue,z);
   _root.moveTo(x1,y1); _root.lineTo(x3,y3);
   _root.moveTo(x2,y2); _root.lineTo(x4,y4);
   _root.lineTo(x5,y5); _root.lineTo(x2,y2);
}


onEnterFrame = function(){
  _root.clear();
  for(i=0;i<=n;i++){
  for(j=0;j<=n;j++){
     xx=_root["field"+i+j]._x;
     yy=_root["field"+i+j]._y;
     tt=_root["field"+i+j]._t;
     _root["field"+i+j]._x=xx+eps*P(xx,yy);
     _root["field"+i+j]._y=yy+eps*Q(xx,yy);
     _root["field"+i+j]._t=tt+dt; 
     if (tt>100) {
       _root["field"+i+j]._t=0;  
       _root["field"+i+j]._x=boundary+dx*i; 
       _root["field"+i+j]._y=boundary+dy*j;
     }
     vec(xx,yy,xx+0.2*P(xx,yy),yy+0.2*Q(xx,yy),1,
        255-2.55*tt,255-2.55*tt,2.55*tt,tt*(100-tt)/25);
  }
  }
};

