/*\
 *  A study: goal: simulate 3D effect using z- transparency
 *  and use keys to navigate the vector 
 *  Last editing: May 16, 2005  before PITF workshop
 *  This Flash actionscript file is part of a PITF project
 *  Copyright (C) 2004-2005,  Oliver Knill, Harvard University
 *  spin off of PITF project Summer 2004 with Presidential IT fellow
 *  David Mahfouda. Visit website www.math.harvard.edu/~knill/pitf
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/


//  global parameters

alpha  = 0;        //  rotation angles
beta   = 0.4;      
gamma  = 0;
x_center  = 200;   // center in space 
y_center  = 200;
z_center  = 200; 
n = 30;            // number of points to draw the vector
r = 30;            // radius of circle 
t = 0;             // parameter for bullet shooting from vector
thick=5;           // line thickness
dgamma=0.1;        // angle increments 
dbeta=0.1; 
dalpha=0.1; 
twopi = 2*Math.PI;  // optimization attempts
oneovertwopi = 1/twopi;

//  time line, main procedure 

onEnterFrame = function() { 
  _root.clear(); 
  keys(); 
  vector(); 
}

//  user input

function keys () {
  if(Key.isDown(Key.UP))        { clear(); gamma = gamma + dgamma; } 
  if(Key.isDown(Key.DOWN))      { clear(); gamma = gamma - dgamma; }
  if(Key.isDown(Key.LEFT))      { clear(); beta  = beta  + dbeta;  } 
  if(Key.isDown(Key.RIGHT))     { clear(); beta  = beta  - dbeta;  } 
  if(Key.isDown(Key.ENTER))     { clear(); alpha = alpha + dalpha; }
  if(Key.isDown(Key.BACKSPACE)) { clear(); alpha = alpha - dalpha; } 
}

//   draw the vector

function vector() {
  cosa = Math.cos(alpha); sina = Math.sin(alpha);
  cosb = Math.cos(beta);  sinb = Math.sin(beta);
  cosg = Math.cos(gamma); sing = Math.sin(gamma);

  x0 = 0; y0 = 0; z0 = -170; 
  xx0 = cosa*cosb*x0+cosb*sina*y0+sinb*z0;
  yy0 = (-cosg*sina-cosa*sinb*sing)*x0+( cosa*cosg-sina*sinb*sing)*y0+cosb*sing*z0;
  zz0 = (-cosa*cosg*sinb+sina*sing)*x0+(-cosg*sina*sinb-cosa*sing)*y0+cosb*cosg*z0;

  xt = 0; yt = 0; zt = -170-t*140;
  xxt = cosa*cosb*xt+cosb*sina*yt+sinb*zt;
  yyt = (-cosg*sina-cosa*sinb*sing)*xt+( cosa*cosg-sina*sinb*sing)*yt+cosb*sing*zt;
  zzt = (-cosa*cosg*sinb+sina*sing)*xt+(-cosg*sina*sinb-cosa*sing)*yt+cosb*cosg*zt;

  xs = 0; ys = 0; zs = -170-t*140-1;
  xxs = cosa*cosb*xs+cosb*sina*ys+sinb*zs;
  yys = (-cosg*sina-cosa*sinb*sing)*xs+( cosa*cosg-sina*sinb*sing)*ys+cosb*sing*zs;
  zzs = (-cosa*cosg*sinb+sina*sing)*xs+(-cosg*sina*sinb-cosa*sing)*ys+cosb*cosg*zs;

  red=255; green=0; blue=0;
  _root.lineStyle(7-zzs/50,red<<16^green<<8^blue,100);
  _root.moveTo(x_center+xxt,y_center+yyt);
  _root.lineTo(x_center+xxs,y_center+yys);

  for (i=0; i<n; i++) {
    theta=twopi*i/n; costheta=Math.cos(theta); sintheta=Math.sin(theta);  
    x1 = r*costheta*2; y1 = r*sintheta*2; z1 = -100;
    x2 = r*costheta;   y2 = r*sintheta;   z2 =  100;

    red  =(costheta+1)*255/2; green=(sintheta+1)*255/2; blue =0; 

    xx1 = cosa*cosb*x1+cosb*sina*y1+sinb*z1; 
    yy1 = (-cosg*sina-cosa*sinb*sing)*x1+( cosa*cosg-sina*sinb*sing)*y1+cosb*sing*z1; 
    zz1 = (-cosa*cosg*sinb+sina*sing)*x1+(-cosg*sina*sinb-cosa*sing)*y1+cosb*cosg*z1;

    xx2 = cosa*cosb*x2+cosb*sina*y2+sinb*z2; 
    yy2 = (-cosg*sina-cosa*sinb*sing)*x2+( cosa*cosg-sina*sinb*sing)*y2+cosb*sing*z2; 
    zz2 = (-cosa*cosg*sinb+sina*sing)*x2+(-cosg*sina*sinb-cosa*sing)*y2+cosb*cosg*z2;

    _root.lineStyle(thick,red<<16^green<<8^blue,30+(100-zz2)/2);
    _root.moveTo(x_center+xx1,y_center+yy1);
    _root.lineTo(x_center+xx2,y_center+yy2); 
    red=(costheta+1)*122.5; green=0; blue=(sintheta+1)*122.5;

    _root.lineStyle(thick,red<<16^green<<8^blue,30+(100-zz1)/2);
    _root.moveTo(x_center+xx0,y_center+yy0);
    _root.lineTo(x_center+xx0+1.5*(xx1-xx0),y_center+yy0+1.5*(yy1-yy0)); 
  }
  if (beta>twopi)     {beta-=twopi; }  if (beta<-twopi)   {beta+=twopi; }
  if (gamma>twopi)    {gamma-=twopi; } if (gamma<-twopi)  {gamma+=twopi; }
  t=t+0.09; if (t>1) { t=0; } 
}

