// A study: goal: simulate 3D effect using transparency
// and use keys to navigate the vector 

alpha  = 0;        //  rotation angles
dalpha = 0.03;     //  speed 
beta   = 0.4;      
gamma  = 0;
x_center  = 200; 
y_center  = 200;
z_center  = 200; 
n = 6;            // number of points to draw the vector
r = 70;            // radius of circle 
red=0; green=0; blue=255; 
thick=5; 
dgamma=0.1; dbeta=0.1; ddalpha=0.01; 

onEnterFrame = function() { 
  _root.clear(); 
  keys(); 
  vector(); 
}

function keys () {
  if(Key.isDown(Key.UP))        { clear(); gamma = gamma + dgamma; } 
  if(Key.isDown(Key.DOWN))      { clear(); gamma = gamma - dgamma; }
  if(Key.isDown(Key.LEFT))      { clear(); beta  = beta  + dbeta;  } 
  if(Key.isDown(Key.RIGHT))     { clear(); beta  = beta  - dbeta;  } 
  if(Key.isDown(Key.ENTER))     { clear(); dalpha  = dalpha + ddalpha; }
  if(Key.isDown(Key.BACKSPACE)) { clear(); dalpha  = dalpha - ddalpha; } 
}


function vector() {
  cosa = Math.cos(alpha); sina = Math.sin(alpha);
  cosb = Math.cos(beta);  sinb = Math.sin(beta);
  cosg = Math.cos(gamma); sing = Math.sin(gamma);

  x0 = 0; y0 = 0; z0 = 0; 
  xx0 = cosa*cosb*x0+cosb*sina*y0+sinb*z0;
  yy0 = (-cosg*sina-cosa*sinb*sing)*x0+( cosa*cosg-sina*sinb*sing)*y0+cosb*sing*z0;
  zz0 = (-cosa*cosg*sinb+sina*sing)*x0+(-cosg*sina*sinb-cosa*sing)*y0+cosb*cosg*z0;

  x5 = 0; y5 = 0; z5 = 50;
  xx5 = cosa*cosb*x5+cosb*sina*y5+sinb*z5;
  yy5 = (-cosg*sina-cosa*sinb*sing)*x5+( cosa*cosg-sina*sinb*sing)*y5+cosb*sing*z5;
  zz5 = (-cosa*cosg*sinb+sina*sing)*x5+(-cosg*sina*sinb-cosa*sing)*y5+cosb*cosg*z5;

  x6 = 0; y6 = 0; z6 = 80;
  xx6 = cosa*cosb*x6+cosb*sina*y6+sinb*z6;
  yy6 = (-cosg*sina-cosa*sinb*sing)*x6+( cosa*cosg-sina*sinb*sing)*y6+cosb*sing*z6;
  zz6 = (-cosa*cosg*sinb+sina*sing)*x6+(-cosg*sina*sinb-cosa*sing)*y6+cosb*cosg*z6;

  x8 = 0; y8 = 0; z8 = 80;
  xx8 = cosa*cosb*x8+cosb*sina*y8+sinb*z8;
  yy8 = (-cosg*sina-cosa*sinb*sing)*x8+( cosa*cosg-sina*sinb*sing)*y8+cosb*sing*z8;
  zz8 = (-cosa*cosg*sinb+sina*sing)*x8+(-cosg*sina*sinb-cosa*sing)*y8+cosb*cosg*z8;


  red=255; green=0; blue=0;
  _root.lineStyle(7-zz8/50,red<<16^green<<8^blue,100);
  _root.moveTo(x_center+xx0,y_center+yy0);
  _root.lineTo(x_center+xx8,y_center+yy8);

  for (i=0; i<n; i++) {
    theta=2*Math.Pi*i/n; costheta=Math.cos(theta); sintheta=Math.sin(theta);  
    x1 = r*costheta; y1 = r*sintheta; z1 = z5;
    x7 = r*costheta; y7 = r*sintheta; z7 = z6;

    red  =(costheta+1)*255/2; 
    green=(sintheta+1)*255/2; 
    blue =0; 

    xx1 = cosa*cosb*x1+cosb*sina*y1+sinb*z1; 
    yy1 = (-cosg*sina-cosa*sinb*sing)*x1+( cosa*cosg-sina*sinb*sing)*y1+cosb*sing*z1; 
    zz1 = (-cosa*cosg*sinb+sina*sing)*x1+(-cosg*sina*sinb-cosa*sing)*y1+cosb*cosg*z1;

    xx7 = cosa*cosb*x7+cosb*sina*y7+sinb*z7; 
    yy7 = (-cosg*sina-cosa*sinb*sing)*x7+( cosa*cosg-sina*sinb*sing)*y7+cosb*sing*z7; 
    zz7 = (-cosa*cosg*sinb+sina*sing)*x7+(-cosg*sina*sinb-cosa*sing)*y7+cosb*cosg*z7;

    _root.lineStyle(thick,red<<16^green<<8^blue,30+(100-zz0)/2);
    _root.moveTo(x_center+xx5,y_center+yy5);
    _root.lineTo(x_center+xx1,y_center+yy1); 
    _root.lineTo(x_center+xx7,y_center+yy7); 
    _root.lineTo(x_center+xx8,y_center+yy8); 
    red=(costheta+1)*255/2; green=0; blue=(sintheta+1)*255/2;
  }

  if (beta>Math.Pi)   {beta=beta-2*Math.Pi; }
  if (beta<-Math.Pi)  {beta=beta+2*Math.Pi; }
  if (gamma>Math.Pi)  {gamma=gamma-2*Math.Pi; }
  if (gamma<-Math.Pi) {gamma=gamma+2*Math.Pi; }
  alpha=alpha+dalpha; if (alpha>2*Math.Pi) { alpha=alpha-2*Math.Pi; } 
}

