/*
 *	RollerCoaster2000
 *	Copyright (C) 2003 Plusplus (plusplus@free.fr)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <math.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#import <Cocoa/Cocoa.h>
#import <gl.h>
#import "TextureString.h"

#ifndef M_PI  /* some math header doesn't define it */
#define M_PI 3.14159265359f
#define MM_PI 6.28318530717f    // optimization
#endif

#define LF 0x0A  /* line feed      */
#define CR 0x0D  /* chariot return */
#define ROLLER_NOERROR 0
#define ROLLER_GLWINDOWCREATION_ERROR 1

#define kPOTEAURAYONLIEN	0.015f

typedef struct coord2d
{
	float x,y;
} coord2d;

typedef struct point
{
	float x,y,z;
} point;

typedef struct
{
	GLuint				texID;
	int					width;
	int					height;
	int					colorDepth;
	int					imageSize;
	NSBitmapImageRep	*bitmap;
	GLint				texWrapS;
	GLint				texWrapT;
	GLint				minFilter;
	GLint				magFilter;
} glBmpImage;

class	RollerCoaster
{
	public:
	
	RollerCoaster();
	~RollerCoaster();
	int		Start(char *rezpath,char *trackname,int width,int height,int intro,int quality,BOOL showFPS);
	void	DrawRoller(unsigned long current);

	private:

	TextureString		*stringtexture;

	point 			light_dir;
	point 			lightAmbient;
	point 			lightDiffuse;
	point 			light;
	point 			panneauPosition;
	point 			panneauDirection;
	point 			metalPosition;
	point			panneau_tabv[8];
	point			panneau_tabc[6];
	coord2d			metal_tabt[12];
	coord2d			metal_tab1t[6];
	point			metal_tab2v[6];
	coord2d			metal_tab2t[6];
	point			metal_tabc[5];
	point			metal_tab1v[6];
	point			metal_tab1c;
	point			metal_tab2c;

	float 			aperture;				/* field of view angle in degree */
	float			near_clip;				/* near clip plane coord */
	float			far_clip;				/* far clip plane coord */
	float			eye_sep;				/* distance between eyes */
	float			focallength;
	float			rayonCyl;
	float			rayonLien;
	float			longueurLien;
	float			maxZ;					/* maximum z coordinate of the curve             */
	float			maxDist;				/* maximum distance of the curve from the origin */
	float			averageSegmentLength;	/* length of segments that the track is made of */
	float			twistFactor;			/* amount of tilt when the track tilt in turns */
	float			rayonPoteau;
	float			distPoteau;
	float			hauteurLien;
	float			metalLength;
	float			metalAngle;

	int				nbCotePoteau;
	int				nbCoteLien;
	int				startSegment;			/* index of segment where the train starts */
	int				brakeSegment;			/* index of segment where the train starts braking */
	int				cave;					/* multi-screen mode if non zero(5 or 6 screens) */
	int				wndWidth,wndHeight;
	int				doIntro;				/* Show coaster before starting the ride. */
	int				nbPointControle;		// points par lesquelles passe la courbe de Bezier
	int				nbLine;					// nombre total de segment du circuit
	int				nbCote;					// nombre de cotes du cylindre
	int				nbLiens;
	int				nbPoteauCoord;
	int				nbPoteauAbsc;
	int				nbTree;
	int				nbPoteau;
	int				nbLien;

	int				nbFrames;
	BOOL			showFPS;
	float			fps;
	
	point			*ppointcontrole;		/* tableau des points de controle tels qu'ils sont dans le fichier */
	point			*pcontrole;				/* tableau des points des courbes de Bezier */
	point			*pline;					// tableau des extremites des segments
	point			*ppos;					// tableau des vecteurs position par rapport a la courbe
	point			*ptraj;
	point			*pcyl;					// tableau des coordonnees des vertex du tuyau
	point			*pline1,*pline2;
	point			*prail1,*prail2;
	point			*prail1n,*prail2n,*pcyln;		// tableau des normales
	point			*pliens;
	point			*pnliens;
	point			*pliensn;
	point			*ptang;					// tangente ‡ la trajectoire en chacun des points
	point			*ppoteaucoord;			/* coordinates were pillars have to be placed */
	point			*ptree;
	point			*ppoteau;
	point			*plien;
	point			*ppoteau_coul;
	point			*plien_coul;
	float			*pnorme;				// longueurs des segments
	float			*pcourbure;				// courbure de la courbe projetÈe sur le plan xy
	int				*ppoteauabsc;			/* abscisses on the track from the start were pillars have to be placed */

	glBmpImage		panneau;
	glBmpImage		metal;
	glBmpImage		arbre;
	glBmpImage		grass;

	FILE			*file;
	int				line_number;
	int				stage;
	unsigned long	firsttime;

	float			scene_abscisse;
	float			scene_oldz;
	float			scene_vitesse;
	int				scene_index;
	int				scene_flag;
	int				scene_flag_stopping;
	unsigned long	scene_stoptime;
	unsigned long	scene_oldtime;
	unsigned long	fpstime;
	
	int		LoadGLTextures(char *rezpath);

	void	InitGL();
	void	ReSizeGLScene(int Width, int Height);
	float	longueur_bezier(point *p1, point *p2, point *p3, point *p4);
	float	rayonDeCourbure(int i, float t);
	void	InitCurve(float longueur_seg);
	void 	calcCercle(point *p, point *z, point *v, int nbCote, float rayon, float angle, point *n, point *pmesh);
	void 	calcTuyau(point *pline, int nbLine, int nbCote, float rayon, float angle, point *pmesh);
	void 	moyenne(float *tab, int nbelem, int nbmoy_pred, int nbmoy_succ);
	void	InitLines();
	void 	InitLiens(float f);
	void 	InitNormales();
	void	InitCouleurs(point *light_dir);
	void 	drawTuyau0(point *ptuyau, point *pnorm, int nbLine, int nbCote, float *mat, point *pline);
	void 	drawTuyau(point *ptuyau, point *pnorm, int nbLine, int nbCote, float *mat, point *pline);
	void	drawLiens(point *pliens, point *pliensn, int nbLiens, float *mat, point *pnliens);
	void	drawSkyAndGround(int nbCote, float size, float texsize,float bas, float haut);
	void	drawEverything();
	void	fade(float opacity);
	void	DrawGLScene0(unsigned long current);
	void	DrawGLScene(unsigned long current,GLfloat roll_angle, GLfloat pitch_angle);
	void	ChangeRollerParameters(float viewAngle, float eyeDist, float focalLength);

	void	cylinder(point* a, point* b, point* v, int nbcote, float rayon, point *buf, point* bufn);
	void	calc_coul(int nb, point* r, point* amb, point* dif, point* lig, point* normale);
	void	create_poteau(point* p1, point* p2, point* v, point* buf, point* bufc);
	void	create_lien(point* p, point* p1, point* p2, point* buf, point* bufc);
	void	draw_poteau(int nb, point *buf, point *bufc);
	void	draw_lien(int nb, point *buf, point *bufc);
	int		est_relie(point* r, point* p, point* p1, point* p2, int i, point* pline, int nbLine);
	void	create_support(point* p, point* v, point* pline, int nbLine);
	void	poteau_init(point *pline, int nbLine, point* ptang);
	void	drawmetal();
	void	drawpanneau();
	void	drawtree();
	void	poteau_draw();
	void	initpanneau();
	void	initmetal();
	
	void	printerror(char *str, ...);
	int 	readchar();
	int 	ungetchar(int c);
	int 	readpoint(point *p);
	int 	readunsignedint(int *i);
	int		readsignedint(int *i);
	int 	skipnewline();
	int 	readname(char *str, int length);
	int 	readpositiveinteger(int *i);
	int 	readfloat(float *f);
	void	skipcomment();
	void	skipwhite();
	int		readseparator();
	int		readfile();
	void	initinfo();
	void	initdefault();
	void	parseFile(char *str);

	void 	mult(point*, float, point*);
	void	add_mult(point*, float, point*);
	float	norme2(point*);
	float	norme(point*);
	void	normalize(point*);
	void 	sub(point*, point*, point*);
	void	add(point*, point*, point*);
	float	prod_scal(point*, point*);
	void	prod_vect(point*, point*, point*);
	void	rotate(point*, point*, float, point*);
	int		intersection(point*, point*, point*, point*, point*);
	void	matrix_mult(float *r, float* a, float *b);
	void	mult_vect(point *r, float *m, point *v);

	void	glBmpInit(glBmpImage* img);
	int		glBmpLoadImage(glBmpImage* img, NSString *fileName);
	void	glBmpGenTexture(glBmpImage* img);
	void	glBmpGenTextureMipMap(glBmpImage* img);
	void	glBmpSetTextureWrap(glBmpImage* img, GLint s, GLint y);
	void	glBmpSetFilter(glBmpImage* img, GLint min, GLint mag);
	void	glBmpBind(glBmpImage* img);
	int		glBmpGetWidth(glBmpImage* img);
	int		glBmpGetHeight(glBmpImage* img);
	int		glBmpGetColorDepth(glBmpImage* img);
	void	glBmpClearMem(glBmpImage* img);
	void	glBmpFreeTexture(glBmpImage* img);

	void	showFrames(unsigned long current);
};
