/*
 *	RollerCoaster2000
 *	Copyright (C) 2003 Plusplus (plusplus@free.fr)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "RollerCoaster.h"

/**
*	RollerCoaster constructor
*/

RollerCoaster::RollerCoaster()
{
	nbFrames = 0;
	fps = 0;
	
	aperture = 60.0f;
	near_clip = 0.01f;
	far_clip = 60.0f;
	startSegment = -5;
	brakeSegment = -20;
	averageSegmentLength = 0.15f;
	twistFactor = 5.0f;
	cave = 1;
	eye_sep = 0.05f;
	focallength = 0.05f;
	doIntro = 1;
	nbCote = 4;
	rayonCyl = 0.02f;
	rayonLien = 0.01f;
	longueurLien = 0.1f;
	maxZ = 0.0f;
	maxDist = 0.0f;
	nbPoteauCoord = 0;
	nbPoteauAbsc = 0;
	nbCotePoteau = 6;
	nbCoteLien = 4;
	rayonPoteau = 0.02f;
	distPoteau = 0.4f;
	hauteurLien = 0.1f;
	metalLength = 2.0f;
	metalAngle = 0.0f;
	
	light_dir.x = 1.0f;
	light_dir.y = -0.5f;
	light_dir.z = 2.0f;

	lightAmbient.x = 0.4f;
	lightAmbient.y = 0.4f;
	lightAmbient.z = 0.4f;

	lightDiffuse.x = 1.0f;
	lightDiffuse.y = 0.9f;
	lightDiffuse.z = 1.0f;

	light.x = 1.0f;
	light.y = 0.5f;
	light.z = 1.0f;

	panneauPosition.x = 0.0f;
	panneauPosition.y = 0.0f;
	panneauPosition.z = 0.0f;

	metalPosition.x = -1.0f;
	metalPosition.y = -1.0f;
	metalPosition.z = 0.5f;

	ppointcontrole = NULL;
	ppoteaucoord = NULL;
	ppoteauabsc = NULL;
	ptree = NULL;

	ppoteau = NULL;
	ppoteau_coul = NULL;
	plien = NULL;
	plien_coul = NULL;

	pcontrole = NULL;
	pline = NULL;

	pcourbure = NULL;
	pnorme = NULL;
	ppos = NULL;
	ptraj = NULL;
	ptang = NULL;
	pcyl = NULL;
	pline1 = NULL;
	pline2 = NULL;
	prail1 = NULL;
	prail2 = NULL;

	pliens = NULL;
	pnliens = NULL;

	prail1n = NULL;
	prail2n = NULL;
	pcyln = NULL;
	pliensn = NULL;

	glBmpInit(&grass);
	glBmpInit(&metal);
	glBmpInit(&arbre);
	glBmpInit(&panneau);

	stringtexture = [[TextureString alloc]initWithFont:[NSFont fontWithName:@"Monaco" size:14.0] withColor:[NSColor whiteColor]];
}

/**
*	RollerCoaster destructor
*/

RollerCoaster::~RollerCoaster()
{
	[stringtexture release];
	
	if (ppointcontrole != NULL) free(ppointcontrole);
	if (ppoteaucoord != NULL) free(ppoteaucoord);
	if (ppoteauabsc != NULL) free(ppoteauabsc);
	if (ptree != NULL) free(ptree);

	if (ppoteau != NULL) free(ppoteau);
	if (ppoteau_coul != NULL) free(ppoteau_coul);
	if (plien != NULL) free(plien);
	if (plien_coul != NULL) free(plien_coul);

	if (pcontrole != NULL) free(pcontrole);
	if (pline != NULL) free(pline);

	if (pcourbure != NULL) free(pcourbure);
	if (pnorme != NULL) free(pnorme);
	if (ppos != NULL) free(ppos);
	if (ptraj != NULL) free(ptraj);
	if (ptang != NULL) free(ptang);
	if (pcyl != NULL) free(pcyl);
	if (pline1 != NULL) free(pline1);
	if (pline2 != NULL) free(pline2);
	if (prail1 != NULL) free(prail1);
	if (prail2 != NULL) free(prail2);

	if (pliens != NULL) free(pliens);
	if (pnliens != NULL) free(pnliens);

	if (prail1n != NULL) free(prail1n);
	if (prail2n != NULL) free(prail2n);
	if (pcyln != NULL) free(pcyln);
	if (pliensn != NULL) free(pliensn);
	
	glBmpFreeTexture(&grass);
	glBmpFreeTexture(&metal);
	glBmpFreeTexture(&arbre);
	glBmpFreeTexture(&panneau);
}

int		RollerCoaster::Start(char *rezpath,char *trackname,int width,int height,int intro,int quality,BOOL showFPS)
{
	int		result;
	point	light_dir={1.0f,-0.5f,2.0f};
	
	this->doIntro = intro;
	this->showFPS = showFPS;
		
	switch (quality)
	{
		case 0:
			nbCote = 4;
			nbCotePoteau = 4;
			nbCoteLien = 2;
			break;
		case 50:
			nbCote = 8;
			nbCotePoteau = 8;
			nbCoteLien = 4;
			break;
		case 100:
			nbCote = 16;
			nbCotePoteau = 16;
			nbCoteLien = 8;
			break;
	}
	
	result = LoadGLTextures(rezpath);
	if (result)
	{
		InitGL();
		ReSizeGLScene(width,height);
		parseFile(trackname);
		InitCurve(averageSegmentLength);
		if(startSegment < 0) startSegment = nbLine + startSegment;
		if(brakeSegment < 0) brakeSegment = nbLine + brakeSegment;
		InitLines();
		InitLiens(0.3f);
		InitNormales();
		InitCouleurs(&light_dir);
		poteau_init(pline,nbLine,ptang);
		initpanneau();
		initmetal();
		
		if (doIntro) stage = 0;
		else stage = 2;
	}
	
	return (result);
}

// Load Bitmaps And Convert To Textures

int		RollerCoaster::LoadGLTextures(char *rezpath)
{
	if (!glBmpLoadImage(&grass,[NSString stringWithFormat:@"%s/grass.tiff",rezpath])) return (0);
	glBmpSetFilter(&grass,GL_LINEAR_MIPMAP_NEAREST,GL_LINEAR);
	glBmpSetTextureWrap(&grass,GL_REPEAT,GL_REPEAT);
	glBmpGenTextureMipMap(&grass);

	if (!glBmpLoadImage(&panneau,[NSString stringWithFormat:@"%s/panneau.tiff",rezpath])) fprintf(stderr,"Error: Can't open texture panneau\n");
	glBmpSetFilter(&panneau,GL_LINEAR,GL_LINEAR);
	glBmpSetTextureWrap(&panneau,GL_CLAMP,GL_CLAMP);
	glBmpGenTexture(&panneau);

	if (!glBmpLoadImage(&metal,[NSString stringWithFormat:@"%s/metal.tiff",rezpath])) fprintf(stderr,"Error: Can't open texture metal\n");
	glBmpSetFilter(&metal,GL_LINEAR_MIPMAP_NEAREST,GL_LINEAR);
	glBmpSetTextureWrap(&metal,GL_REPEAT,GL_REPEAT);
	glBmpGenTextureMipMap(&metal);

	if (!glBmpLoadImage(&arbre,[NSString stringWithFormat:@"%s/tree.tiff",rezpath])) return (0);
	glBmpSetFilter(&arbre,GL_LINEAR,GL_LINEAR);
	glBmpSetTextureWrap(&arbre,GL_CLAMP,GL_CLAMP);
	glBmpGenTexture(&arbre);

	return (1);
}
