/*
 *	RollerCoaster2000
 *	Copyright (C) 2003 Plusplus (plusplus@free.fr)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import "TextureString.h"

@implementation TextureString

- (id) initWithFont:(NSFont *)font withColor:(NSColor *)color
{
	int					i;
	char				s[128-32+1];
	NSBitmapImageRep	*bitmap;
	NSImage				*image;
	NSAttributedString	*string;
	NSMutableDictionary	*attributes;
	
	for (i=32;i<128;i++) s[i-32] = i;
	s[128-32] = 0;
	
	attributes = [NSMutableDictionary dictionaryWithCapacity:2];
	[attributes setObject:font forKey:NSFontAttributeName];
	[attributes setObject:color forKey:NSForegroundColorAttributeName];
	string = [[NSAttributedString alloc]initWithString:[NSString stringWithCString:s] attributes:attributes];

	size = [string size];
	charWidth = size.width / (128 - 32);
	image = [[NSImage alloc] initWithSize:size];
	[image lockFocus];

	[[NSColor colorWithDeviceRed:1.0f green:0.0f blue:0.0f alpha:1.0f] set];
	[string drawAtPoint:NSMakePoint(0.0f,0.0f)];

	bitmap = [[NSBitmapImageRep alloc] initWithFocusedViewRect:NSMakeRect(0.0f,0.0f,size.width,size.height)];
	[image unlockFocus];

	glGenTextures (1,&texture);
	glEnable(GL_TEXTURE_RECTANGLE_EXT);
	glBindTexture(GL_TEXTURE_RECTANGLE_EXT,texture);
	glTexImage2D(GL_TEXTURE_RECTANGLE_EXT,0,GL_RGBA,size.width,size.height,0,GL_RGBA,GL_UNSIGNED_BYTE,[bitmap bitmapData]);
	glDisable(GL_TEXTURE_RECTANGLE_EXT);

	[bitmap release];
	[image release];
	[string release];
	
	return (self);
}

- (void)draw:(NSString *)string AtPoint:(NSPoint)point
{
	GLint			matrixMode;
	float			width,height;
	unsigned char	*str,c;
	float			x;
	
	width = 1024.0;
	height = 768.0;
	
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_TEXTURE_RECTANGLE_EXT);
	glGetIntegerv(GL_MATRIX_MODE,&matrixMode);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity ();
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	glScalef (2.0f / width, -2.0f /  height, 1.0f);
	glTranslatef (-width / 2.0f, -height / 2.0f, 0.0f);
	glColor4f (1.0, 1.0, 1.0, 1.0);

	glBindTexture (GL_TEXTURE_RECTANGLE_EXT,texture);
	str = [string cString];

	while (*str != 0)
	{
		c = *str++;
		if (c>=32 && c<128)
		{
			x = (c - 32) * charWidth;
			
			glBegin (GL_QUADS);

			glTexCoord2f (x,0.0f);
			glVertex2f (point.x, point.y);
	
			glTexCoord2f (x, size.height);
			glVertex2f (point.x, point.y + size.height);
		
			glTexCoord2f (x+charWidth, size.height);
			glVertex2f (point.x + charWidth, point.y + size.height);
		
			glTexCoord2f (x+charWidth, 0.0f);
			glVertex2f (point.x + charWidth, point.y);
			
			glEnd ();
			
			point.x += charWidth;
		}
	}
	
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(matrixMode);
	glDisable(GL_TEXTURE_RECTANGLE_EXT);
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);
}

@end
