/*
 *	RollerCoaster2000
 *	Copyright (C) 2003 Plusplus (plusplus@free.fr)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "RollerCoaster.h"
#include <glu.h> 				/* for gluBuild2DMipmaps */

int		RollerCoaster::glBmpGetWidth(glBmpImage* img)
{
	return img->width;
}

int		RollerCoaster::glBmpGetHeight(glBmpImage* img)
{
	return img->height;
}

int		RollerCoaster::glBmpGetColorDepth(glBmpImage* img)
{
	return img->colorDepth;
}

void	RollerCoaster::glBmpClearMem(glBmpImage* img)
{
	if (img->bitmap)
	{
		[img->bitmap release];
        img->bitmap = NULL;
	}
}

void	RollerCoaster::glBmpInit(glBmpImage* img)
{
	img->width = 0;
	img->height = 0;
	img->colorDepth = 0;
	img->bitmap = 0;
	img->texID = 0;

	img->texWrapS = GL_CLAMP;
	img->texWrapT = GL_CLAMP;
	img->minFilter = GL_LINEAR;
	img->magFilter = GL_LINEAR;
}

int		RollerCoaster::glBmpLoadImage(glBmpImage* img,NSString *fileName)
{
	int			result;
	NSImage		*image;
	
	glBmpClearMem(img);

	image = [[NSImage alloc]initWithContentsOfFile:fileName];
	if (image == NULL) result = 0;
	else
	{
		img->bitmap = [[NSBitmapImageRep alloc]initWithData: [image TIFFRepresentation]];
		if (img->bitmap == NULL) result = 0;
		else
		{
			img->width = (int) [img->bitmap size].width;
			img->height = (int) [img->bitmap size].height;
			img->colorDepth = [img->bitmap bitsPerPixel];
			result = 1;
		}
		[image release];
	}
		
	return (result);
}

void	RollerCoaster::glBmpGenTexture(glBmpImage* img)
{
	GLenum	format;

	if (img->texID) glDeleteTextures(1, &img->texID);

	glGenTextures(1, &img->texID);
	glBindTexture(GL_TEXTURE_2D, img->texID);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, img->texWrapS);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, img->texWrapT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, img->magFilter);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, img->minFilter);

	if ([img->bitmap hasAlpha]) format = GL_RGBA;
	else format = GL_RGB;

	glTexImage2D(GL_TEXTURE_2D, 0, 4, img->width, img->height, 0, format, GL_UNSIGNED_BYTE, [img->bitmap bitmapData]);
}


void	RollerCoaster::glBmpGenTextureMipMap(glBmpImage* img)
{
	GLenum	format;

	if (img->texID) glDeleteTextures(1, &img->texID);

	glGenTextures(1, &img->texID);
	glBindTexture(GL_TEXTURE_2D, img->texID);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, img->texWrapS);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, img->texWrapT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, img->magFilter);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, img->minFilter);

	if ([img->bitmap hasAlpha]) format = GL_RGBA;
	else format = GL_RGB;

//	glTexImage2D(GL_TEXTURE_2D, 0, 4, img->width, img->height, 0, format, GL_UNSIGNED_BYTE, [img->bitmap bitmapData]);
	gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, img->width, img->height, format, GL_UNSIGNED_BYTE, [img->bitmap bitmapData]);
}

void	RollerCoaster::glBmpSetFilter(glBmpImage* img, GLint min, GLint mag)
{
	switch (min)
	{
		case GL_NEAREST : img->minFilter = GL_NEAREST; break;
		case GL_LINEAR : img->minFilter = GL_LINEAR; break;
		case GL_NEAREST_MIPMAP_NEAREST : img->minFilter = GL_NEAREST_MIPMAP_NEAREST; break;
		case GL_LINEAR_MIPMAP_NEAREST : img->minFilter = GL_LINEAR_MIPMAP_NEAREST; break;
		case GL_NEAREST_MIPMAP_LINEAR : img->minFilter = GL_NEAREST_MIPMAP_LINEAR; break;
		case GL_LINEAR_MIPMAP_LINEAR : img->minFilter = GL_LINEAR_MIPMAP_LINEAR; break;
		default : img->minFilter = GL_LINEAR;
	}
	switch (mag)
	{
		case GL_NEAREST : img->magFilter = GL_NEAREST; break;
		case GL_LINEAR : img->magFilter = GL_LINEAR; break;
		default : img->magFilter = GL_LINEAR;
	}
}

void	RollerCoaster::glBmpSetTextureWrap(glBmpImage* img, GLint s, GLint t)
{
	switch (s)
	{
		case GL_CLAMP : img->texWrapS = GL_CLAMP; break;
		case GL_REPEAT : img->texWrapS = GL_REPEAT; break;
		case GL_CLAMP_TO_EDGE : img->texWrapS = GL_CLAMP_TO_EDGE; break;
	}
	switch (t)
	{
		case GL_CLAMP : img->texWrapT = GL_CLAMP; break;
		case GL_REPEAT : img->texWrapT = GL_REPEAT; break;
		case GL_CLAMP_TO_EDGE : img->texWrapT = GL_CLAMP_TO_EDGE; break;
	}
}


void	RollerCoaster::glBmpBind(glBmpImage* img)
{
	if (img->texID) glBindTexture(GL_TEXTURE_2D, img->texID);
}

void	RollerCoaster::glBmpFreeTexture(glBmpImage* img)
{
	glBmpClearMem(img);

	if (img->texID)
	{
		glDeleteTextures(1, &img->texID);
		img->texID = 0;
	}
}
